\ 2006-07-25 EW adv2_i2c_lm75.fs
\ read temp sensor, controlbyte: 0x00
: get.T ( -- xh xl )
  0 1 i2c_addr_lm75 NB>i2c
  2 i2c_addr_lm75 NB<i2c
;
\ bake 2 Bytes into T scaled 10
\ "*/" takes care of the sign :-)
: decode.T ( xh xl -- T*10 )
  $80 and     \ ( xl & 0x80 )
  swap 
  8 lshift    \ ( xh << 8 )
  +           \ ( xh<<8 + (xl & 0x80) )
  5 128 */    \ *10 / 256 ( scale to 1/10 C )
;
\ format T for display (type or lcdtype)
: format.T ( T*10 -- )
  dup >R      \ <# expects unsigned double,
  abs s>d     \ so create one
  <# # 46 hold # # R> sign! #>  \ %+5.1f
  \ get sign back from return stack
;
\ assume lcdpos has been issued before
: show.T ( -- )
  get.T decode.T format.T lcdtype
;