\ 2006-08-18 EW adv2_3.fs
rom
include adv2_timeup.fs
: led0 ( -- ) 3 port1 bclr ;
: led1 ( -- ) 3 port1 bset ;
: job.tick ( -- )
  tick @ $01 and IF led0 ELSE led1 ENDIF
;
: job.sec ( -- )
  timer @ dup lastsec @ - swap dup lastsec !
  sec @ min @ hour @ day @ month @ year @
  cr . . . . . . . .
;
: job.min ( -- )
  cr ." running minute job ..."
;
: job.hour ( -- )
  cr ." running hour job ..."
;
: job.day ( -- )
  cr ." running day job ..."
;
: job.month ( -- )
  cr ." running month job ..."
;
: job.year ( -- )
  cr ." running year job ..."
;
: init-loop ( -- )
  cr ." year month day hour min sec timer"
  ." timer-lastsec"
  timer @ cycles.tick + newtimer !
  job.sec
;
ram
create Jobs ' job.tick , 
  ' job.sec , ' job.min , ' job.hour ,
  ' job.day , ' job.month , ' job.year ,
rom
: run
  init-loop
  BEGIN
    tickover? IF timeup ENDIF
    7 0 DO
      I Flags btst IF
      I cells Jobs + @ execute
      I Flags bclr
      ENDIF
    LOOP
  key? UNTIL
;
ram