\ 2006-08-16 EW adv2_2.fs
rom
include adv2_timeup.fs
: led0 ( -- ) 3 port1 bclr ;
: led1 ( -- ) 3 port1 bset ;
: job.tick ( -- )
  tick @ $01 and IF led0 ELSE led1 ENDIF
;
: job.sec ( -- )
  timer @ dup lastsec @ - swap dup lastsec !
  sec @ min @ hour @ day @ month @ year @
  cr . . . . . . . .
;
: job.min ( -- )
  cr ." running minute job ..."
;
: job.hour ( -- )
  cr ." running hour job ..."
;
: job.day ( -- )
  cr ." running day job ..."
;
: job.month ( -- )
  cr ." running month job ..."
;
: job.year ( -- )
  cr ." running year job ..."
;
: init-loop ( -- )
  cr ." year month day hour min sec timer"
  ." timer-lastsec"
  timer @ cycles.tick + newtimer !
  job.sec
;
: run
 init-loop
 BEGIN
  tickover? IF timeup ENDIF
  0 Flags btst IF job.tick 0 Flags bclr ENDIF
  1 Flags btst IF job.sec  1 Flags bclr ENDIF
  2 Flags btst IF job.min  2 Flags bclr ENDIF
  3 Flags btst IF job.hour 3 Flags bclr ENDIF
  4 Flags btst IF job.day  4 Flags bclr ENDIF
 5 Flags btst IF job.month 5 Flags bclr ENDIF
  6 Flags btst IF job.year 6 Flags bclr ENDIF
 key? UNTIL
;
ram