\ ====== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ==|
\ singen.fs - last edit: 13-feb-2015 19:50 -jgt
  cr ." included: singen.fs"
\ Hier werden die Sinuskurven berechnet.
\ ------------------------------------------------------------------------

\ | 0xxx xxxx xxxx xxxx |   Tondauer (1 bis 28800 = 10 Takte)
\ | 10mm sssx xxxx xxxx |   Pitch (max 109) (mm/sss = Manual/Stimme)
\ | 10mm sss0 0000 0000 |   Pause
\ | 10mm sss1 1111 1111 |   Fortklingen

        2  constant   #manuals      \ Anzahl Manuale
        2  constant   #voices       \ Anzahl Stimmen pro Manual
        2  constant   #partials     \ Anzahl Teiltoene pro Stimme
  .99994e  fconstant  damp          \ Daempfung (Ablkingen)
  
        0  value      manu#         \ Manual #
        0  value      lvox#         \ Stimme # lokal
        0  value      gvox#         \ Stimme # global
        0  value      lpart#        \ Teilton # lokal
        0  value      gpart#        \ Teilton # global
        0  value      durat         \ Tondauer	
        0  value      habit         \ Anzahl Stimmen (not used)

           fvariable  accu          \ Sinuswerte aufaddieren
\ ------------------------------------------------------------------------

\ Tabelle der Float-Werte, jedem Teilton zugeordnet.
\ 2 Manuale, 4 Stimmen, 8 Teiltoene (kuenftig 4 Manuale, 24 Stimmen).
\ je Teilton (floating) Phase (p), Phasenschritt (s), Huellkurve (e).
\
create gtable  #manuals #voices #partials 24 * * * allot
\
\     -------------------------------------------------
\     |        Manual-A       |        Manual-B       |   p = phase
\     |   voice1  |   voice2  |   voice1  |   voice2  |   s = step
\     | p | s | e | p | s | e | p | s | e | p | s | e |   e = envelope
\     -------------------------------------------------
\       0   8  16  24  32  40  48  56  64  72  80  88 (96)
\
\ ------------------------------------------------------------------------

\ Zur Funktion von fsin:
\      0e    (  0 Grad) fsin f. 0. ok
\ pi 180e f/ (  1 Grad) fsin f. 0.01745241  ok
\ pi   6e f/ ( 30 Grad) fsin f. 0.5  ok
\ pi   2e f/ ( 90 Grad) fsin f. 1.  ok
\ pi         (180 Grad) fsin f. 0.  ok (ca.)

            360 constant   dots	      \ Aufloesung 2pi (360 Stuetzpunkte)
       dots s>f fconstant  fdots      \ Aufloesung 2pi (floating)
  2pi fdots f/  fconstant  resol      \ Umrechnung 2pi -> Grad

create sintab  dots 8 * allot

\ Grundton zusammen mit Obertoenen in Tabelle sintab laden
: filltab  ( --)
            dots 0 do
               resol i      s>f f* fsin .7e  f*     \ Grundton
               resol i  2*  s>f f* fsin .1e  f* f+
               resol i  3 * s>f f* fsin .3e  f* f+
               resol i  4 * s>f f* fsin .1e  f* f+
               resol i  5 * s>f f* fsin .2e  f* f+
               resol i  6 * s>f f* fsin .3e  f* f+
               resol i  7 * s>f f* fsin .05e f* f+
               resol i  8 * s>f f* fsin .1e  f* f+
               resol i  9 * s>f f* fsin .1e  f* f+
               resol i 10 * s>f f* fsin .2e  f* f+
               resol i 11 * s>f f* fsin .05e f* f+
               resol i 12 * s>f f* fsin .3e  f* f+
               resol i 13 * s>f f* fsin .05e f* f+
               resol i 14 * s>f f* fsin .05e f* f+
               resol i 15 * s>f f* fsin .1e  f* f+
               resol i 16 * s>f f* fsin .1e  f* f+
               sintab i 8 * + f!
            loop ;

: testtab   dots 0 do sintab i . i 8 * + f@ f. cr loop ;

\       0    fsin2 f. 0.  ok                    \   0 Grad
\ pi 6e f/   fsin2 f. 0.5  ok                   \  30 Grad
\ pi 2e f/   fsin2 f. 1.0  ok                   \  90 Grad
\ pi         fsin2 f. -0.  ok                   \ 180 Grad
\ pi 1.5e f* fsin2 f. -1.                       \ 270 Grad
\ pi 2e f*   fsin2 f. 0. ok                     \ 360 Grad

: fsin2  ( arc -- sin)                          \ 16 % langsamer als fsin
            2pi fmod                            \ ( --) ( arc)
            resol f/                            \ ( f1) ( dots)
            fround f>s                          \ ( f1 dots)
            8 * sintab +                        \ ( f1 loc)
            f@ ;
    
\ Sinus-Stuetzpunkte berechnen
\ Erster Aufruf: Timer gesetzt, Phase=0, Phasenschritt gesetzt.
\ Der Sinuswert (max. plus/minus 1) mal "volume" wird aufaddiert.
\ Die Phase wird um den Phasenschritt erhoeht.
\ Die Funktion fsin2 liest die Sinustabelle (mit Obertoenen) aus.
\ Ersetzt man fsin2 durch fsin, so erklingen nur Grundtoene. 
\
: generate  ( --)
     gvox# 24 * gtable + dup f@ fsin2           \ Sinuswert aus Phase
                         dup 16 + f@ f*         \ Sinuswert mal Huellkurve
                             accu f+!           \ auf Akku aufaddieren
                         dup  8 + f@            \ Phasenschritt
                         dup      f+!           \ auf Phase aufaddieren
                    16 + dup f@  damp f* f! ;   \ Huellkurve daempfen
   
\ ------------------------------------------------------------------------

: >voice  ( voice manual -- gvoice)             \ Stimmen-Nummer
    #voices * + ;

: >partial  ( partial voice manual -- gpart)    \ Teilton-Nummer
    >voice  #partials * + ; 

: >mpart  ( partial manual -- mpart)            \ Teilton eines Manuals
    #partials * + ;

\ Schleifen fuer Manuale, Stimmen und Teilstimmen
\ Fuer jede Teilstimme wird ein Kurvenpunkt berechnet.
\
: loops  ( --)
    durat 2* 0                                  \ Tondauer (17 bit)
    ?DO
        0e accu f!                              \ Akku leeren
        #manuals 0
        ?DO  i                     to manu#     \ Manual-Nummer
            #voices 0
            ?DO  i                 to lvox#     \ Stimmen-Nummer
                i j       >voice   to gvox#     \ dito fortlaufend
                generate                        \ Teilton bearbeiten
            LOOP
        LOOP
        accu f@ .5e f+ f>s w>buf                \ in die Wave-Datei
    LOOP ;

\ ------------------------------------------------------------------------
\
\ Stimmen laden (Phase, Step, Envelope fuer Grund- und 2. Oberton)
\ Volle Amplitude: envelope = 32767e maximal (bei nur einer Stimme)

: >A1  ( u --)           0e gtable       f!
                  fadr12 f@ gtable   8 + f!
                      5000e gtable  16 + f! ;

: >A2  ( u --)           0e gtable  24 + f!
                  fadr12 f@ gtable  32 + f!
                      5000e gtable  40 + f! ;

: >B1  ( u --)           0e gtable  48 + f!
                  fadr12 f@ gtable  56 + f!
                      5000e gtable  64 + f! ;

: >B2  ( u --)           0e gtable  72 + f!
                  fadr12 f@ gtable  80 + f!
                      5000e gtable  88 + f! ;

\ Partiturschleife: Akkord fuer Akkord
\ Phase=0, Timer und Tonhoehen laden, Generator starten
\ Die Tonnummern werden mit 1- zu Offset korrigiert
: waves  ( --)
    filltab                         \ Sinustabelle fuellen
    tunelen 0                       \ Partiturlaenge (Akkordzeilen)
    ?DO
        tune i 12 * +               \ 10 Bytes (2 Tondauer, 4*2 Tonhoehe)
        dup      uw@  to durat      \ Tondauer
        dup  2 + uw@  to habit      \ 4 => 4 Werte folgen (not used)
        dup  4 + uw@  1- >A1        \ Manual A. Stimme 1 (1)
        dup  6 + uw@  1- >A2        \ Manual A, Stimme 2 (2)
        dup  8 + uw@  1- >B1        \ Manual B, Stimme 1 (3)
            10 + uw@  1- >B2        \ Manual B, Stimme 2 (4)
        loops
    LOOP ;
\ =========[ Ende von singen.fs ]=========================================
