\ ====== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ==|
\ WAVER3-04.fs - last edit: 11-feb-2015 22:50 -jgt
\               _____________________________________
\              |                                     |
\              |        W a v e   E n g i n e        |   ============
\              |                                     |   Gforth 0.7.0
\              |            Version 3-04             |   ============
\              |_____________________________________|
\
\ Mit der Version 3-03 (beschrieben in VD 2013-04) wird eine Wave-Datei
\ berechnet, die einige vierstimmige Akkorde erklingen laesst. Dafuer
\ stehen zwei "Manuale" zu je zwei Stimmen bereit, wobei jede Stimme aus
\ zwei Teiltoenen (Grundton und Oberton) besteht.
\
\ Ziel ist der Vollausbau mit 4 Manualen zu je 6 Stimmen, jede bestehend
\ aus 16 Teiltoenen. Bei 44,1 kHz Abtastrate sind im Abstand von rund 23
\ Mikrosekunden (Abspielzeit) 4*6*16 = 384 Sinuswerte zu berechnen.
\
\ Mit dieser Version 3-04 wird das Berechnen der Wave-Datei durch zwei
\ Massnahmen beschleunigt: 1) Ersetzen der Funktion "fsin" durch eine
\ Sinustabelle; 2) Integrieren der Teiltoene in diese Tabelle, so dass
\ diese nicht "live" berechnet zu werden brauchen.

\ Konstanten fuer den Wave-Generator
      true   constant  mono          \ true: 1 Kanal, false: 2 Kanaele
      false  constant  stereo        \ true: Raumklang, false: identisch
      false  constant  prelist       \ true: Text vor den Wave-Daten

    s" WAVER3-04"      2constant version    \ Versionsbezeichnung
    s" WE-001.wav"     2constant wavefile   \ Name der Ausgabedatei

    s" goodies.fs"     included
    s" freqtab.fs"     included

    s" wavgen.fs"      included             \ Wave-Generator
    s" partitur.fs"    included             \ Notenblatt
    s" singen.fs"      included  cr cr      \ Sinus-Generator

\ ------------------------------------------------------------------------

\ Wave-Daten in dataChunk einfuegen
: append-data  ( --)
            4 ( 0000) nulls                 \ Pause vorab
              bytecnt @
           16 align-nulls                   \ Pausenende justieren
              waves                         \ Wave-Daten schreiben
              bytecnt @ 4 -                 \ 4 Pos. nach rechts
           16 align-nulls                   \ 0...15 Null-Bytes
              bytecnt @ dataend ! ;         \ Chunk-Ende merken

\ Text in listChunk einfuegen
: append-text  ( --)
              s"   [ "              $>buf
              s" Wave Engine 3.03"  $>buf
              s" edit 131110-1710"  $>buf   \ editiert: ...
              s" comp "             $>buf   \ compiliert: ...
              timestamp                     \ aktuelles Datum
              s"  ]"                $>buf   \ Text-Ende
                                            \ Leerzeichen anhaengen
              bytecnt @  4 -                \ 4 Pos. nach rechts
           16 align-spaces                  \ 0...15 Leerzeichen
              bytecnt @ listend ! ;         \ Chunk-Ende merken

: init  ( --) ;

\ ------------------------------------------------------------------------

\                      H A U P T - R O U T I N E

: build-wavefile  ( --)
                    init
                    create-outfile          \ Wave-Datei anlegen
                    build-waveChunk         \ erste 12 Bytes
                    build-formatChunk       \ weitere 24 Bytes
     prelist IF
                    build-listChunk         \ listChunk ohne Text
                      append-text           \ Text anhaengen
                    build-dataChunk         \ dataChunk ohne Daten
                      append-data           \ Wave-Daten anhaengen
             ELSE
                    build-dataChunk         \ dataChunk ohne Daten
                      append-data           \ Wave-Daten anhaengen
                    build-listChunk         \ listChunk ohne Text
                      append-text           \ Text anhaengen
             ENDIF
                    patch-waveChunkSize     \ Laenge ueber alles
                    patch-dataChunkSize     \ Laenge dataChunk
                    patch-listChunkSize     \ Laenge listChunk
                    fillup                  \ Fuellbytes
                    close-outfile ;         \ Wave-Datei schlieszen

\                              S T A R T
: go  build-wavefile
           ."  fertig! " .s f.s  cr ;       \ "<0> <0>" = Stacks okay

    version  type  ."    >>>--->  Mit 'go' starten!  <---<<< " cr cr

\ =======[ Ende von WAVER3-04.fs ]========================================

