
\ Diese 10 Kommandos sind schon beschrieben worden:
: _begin  ( -- )  ... ;
: _color  { r g b a -- } ... ;
: _clear  ( -- ) ... ;
: _line  { x1 y1 x2 y2 -- }  ... ;
: _rect  { x y w h f -- }  ... ;
: _oval  { x y w h f -- }  ... ;
: _circle  { x y r f -- )  ... ;
: _plot-on  ( -- )  ... ;
: _plot  { x y }  ... ;
: _plot-off  ( -- )  ... ;
: _pause  { s -- }  ... ;
: _show  ( -- )  ... ;
: _end  ( -- )  ... ;

\ Ellipsenbogen zeichnen (hohl oder gefuellt)
: _arc  { x y w h b a f }  ." arc "
        $AA0B 2>buf  x 2>buf  y 2>buf  w 2>buf  h 2>buf
                     b 2>buf  a 2>buf  f 2>buf ;

\ Tortenstueck zeichnen (hohl oder gefuellt)
: _pie  { x y w h b a f }  ." arc "
        $AA0C 2>buf  x 2>buf  y 2>buf  w 2>buf  h 2>buf
                     b 2>buf  a 2>buf  f 2>buf ;

\ Zeichensatz und Hoehe waehlen
: _font  { typ h }  ." font "
        $AA0D 2>buf  typ 2>buf  h 2>buf ;

\ Text einfuegen (big endian)
: _text-on   { x y }  ." text-on "
        $AA0E 2>buf  x 2>buf  y 2>buf ;
: _text      { abc }  ." text "  abc 2>buf ;
: _text-off  ( -- )   ." text-off "  $AA00 2>buf ;

\ Bezugsort waehlen
: _origin  { x y }  ." origin "
        $AA0F 2>buf  x 2>buf  y 2>buf ;

\ Nachfolgenden Plot drehen
: _rotate  { a }  ." rotate "
        $AA10 2>buf  a 2>buf ;

\ Rechteck mit runden Ecken zeichnen (hohl oder gefuellt)
: _rndrect  { x y w h r f }  ." rndrect "
        $AA11 2>buf  x 2>buf  y 2>buf  w 2>buf  h 2>buf
                     r 2>buf  f 2>buf ;

\ Dreieck zeichnen (hohl oder gefuellt)
: _triang  { x1 y1 x2 y2 x3 y3 f }  ." triang "
        $AA12 2>buf  x1 2>buf  y1 2>buf  x2 2>buf  y2 2>buf
                     x3 2>buf  y3 2>buf  f 2>buf ;

\ Grafikausrichtung speichern
: _save  ( -- )  ." save "
        $AA13 2>buf ;

\ Grafikausrichtung wiederherstellen
: _restore  ( -- )  ." restore "
        $AA14 2>buf ;


\ #######################
\ Eine Grafik formulieren
\ #######################

  create-wfile                    \ Ausgabe-Datei erzeugen

: go                                  _begin      \ Dateibeginn

    0    0    0  255                  _color      \ schwarz
                                      _clear      \ ausfuellen
  255  255  255  255                  _color      \ weiss

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  400  300  800  600              0   _rect       \ Rechteck
  400  300 1200  900                  _line       \ Diagonale
 1200  300  400  900                  _line       \ Diagonale

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  400  300  800  600              0   _oval       \ Ellipse

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  800  500  200                   0   _circle     \ Kreis

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  627  330  350  350  220  100    1   _pie        \ Torte

  100  100  100  255                  _color      \ grau

  400  300  800  600   45   90    1   _arc        \ Bogen

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  255  255  255  255                  _color      \ weiss

  350  250  900  700   50         0   _rndrect    \ runde Ecken

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

                                      _save       \ Drehrichtung
                                -10   _rotate     \ Drehung links

                                      _plot-on
  980 0 do i 200 + i s>f 30e f/ fsin 100e f* 770e f+ f>s
                                      _plot       \ Sinus
        loop                          _plot-off

                                      _restore    \ Drehung vergessen

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  100  100  100  255                  _color      \ grau

 1300  900 1700  500 1400  300    1   _triang     \ volles Dreieck

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  255  255  255  255                  _color      \ weiss

 1500  650 1600  460 1400  460    1   _triang     \ volles Dreieck

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  190  940                            _origin     \ neuer Bezugspunkt

                                -90   _rotate     \ Drehung links

                             3   70   _font       \ 3 = Serif 

  135  100                            _text-on    \ Text x y
       256 [char] H *  [char] e  +    _text       \ "Hello World "
       256 [char] l *  [char] l  +    _text
       256 [char] o *    bl      +    _text
       256 [char] W *  [char] o  +    _text
       256 [char] r *  [char] l  +    _text
       256 [char] d *    bl      +    _text
                                      _text-off

                                      _show       \ zeigen
                                100   _pause      \ 100 Sekunden

                                      _end ;      \ Dateiende

       go      \ Autostart
