\ ==+=== 1 ===+=== 2 ===+=== 3 ===+=== 4 ===+=== 5 ===+=== 6 ===+====
\ plotter.fs - last edit: 30-jun-2014 14:30 -jgt
\
\ ################################################################### 
\ Generieren einer durch Mobile Basic zu interpretierenden Plot-Datei
\ ###################################################################
\ 
\ Es sind 20 Befehle vorhanden, mit denen u. a. Linien, Kreise,
\ Ellipsen, Rechtecke, Dreiecke, Schrift und einzelne Pixel gesetzt
\ werden koennen. Geschlossene Figuren (RECT, RNDRECT, TRIANG,
\ CIRCLE, OVAL, ARC, PIE) lassen sich wahlweise mit aktueller Farbe
\ ausfuellen.
\
\ Die Befehle werden jeweils durch Kennnummern ($AAxx) eingeleitet.
\ Kennnummern und Parameter haben jeweils 16 bit Breite.
\
\ Fuer den Befehl PLOT sind als Parameter beliebig viele xy-Paare
\ zugelassen, die durch eine Ende-Kennung abgeschlossen werden.
\
\ Aehnlich wird fuer TEXT verfahren; hier ist eine beliebig lange
\ Kette Doppelbytes mit je 2 Zeichen erlaubt (das erste Zeichen
\ im Byte mit der hoeherwertigen Adresse, "big endian") und mit
\ einer Ende-Kennung abgeschlossen. 
\
\ CLEAR fuellt den Bildschirm mit vorgewaehlter Farbe, SHOW macht
\ die gesetzte Grafik sichtbar.
\
\ Die Ellipsensegmente ARC und PIE unterscheiden sich durch die
\ Verbindung der Bogenenden (direkt oder ueber Ellipsenmitte).
\
\ ROTATE dreht die Koordinaten, deren alter Zustand mit SAVE und
\ RESTORE bewahrt werden kann.
\
\   "_color"    [$AA01|<red>|<grn>|<blu>|<alp>]>
\   "_clear"    [$AA02]
\   "_line"     [$AA03| <x1>| <y1>| <x2>| <y2>]
\   "_rect"     [$AA04| <x> | <y> |<wid>|<hig>| <f> ]
\   "_oval"     [$AA05| <x> | <y> |<wid>|<hig>| <f> ]
\   "_circle"   [$AA06| <x> | <y> |<rad>| <f> ]
\   "_plot"     [$AA07| <x1>| <y1>| <x2>| <y2>| ... | ... |$AA00]
\   "_pause"    [$AA08|<sec>]
\   "_show"     [$AA09]
\   "_end"      [$AA0A]
\   "_arc"      [$AA0B| <x> | <y> |<wid>|<hig>|<beg>|<arc>| <f> ]
\   "_pie"      [$AA0C| <x> | <y> |<wid>|<hig>| <b> |<arc>| <f> ]
\   "_font"     [$AA0D|<typ>|<hig>]
\   "_text"     [$AA0E| <x> | <y> | a b | c d | ... |$AA00]
\   "_origin    [$AA0F| <x> | <y> ]
\   "_rotate"   [$AA10|<arc>]
\   "_rndrect"  [$AA11| <x> | <y> |<wid>|<hig>|<rad>| <f> ]
\   "_triang"   [$AA12| <x1>| <y1>| <x2>| <y2>| <x3>| <y3>| <f> ]
\   "_save"     [$AA13]
\   "_restore"  [$AA14] 

  s" plot.dat" 2constant  wfile       \ Plotdateiname
  0            value      wfileID     \ Dateikennung
  2000         constant   bufsize     \ Puffergroesse
               variable   bufcnt      \ Pufferzaehler
               variable   tmp         \ Fluechtige Variable

create wbuffer bufsize allot          \ Schreibpuffer

\ Ausgabedatei erzeugen 
: create-wfile  ( --)
            wfile R/W BIN  ( c-addr u fam )
            CREATE-FILE    ( fileid ior )
      IF    ." couldn't create " wfile type ."  - quit" quit
      THEN  to wfileID ;

\ Daten in Wave-Datei schreiben.
: >file  ( addr len)  wfileID  WRITE-FILE ( ior ) drop ;

\ Schreibpuffer leeren und in Datei schreiben.
\ FLUSH-FILE leert auch den unsichtbaren Zwischenspeicher.
\ Am Programmende ist der Puffer mit bufflush zu leeren.
: bufflush  ( -- )
            wbuffer bufcnt @ >file
            0 bufcnt !
            wfileID FLUSH-FILE drop ;

\ Schreibpuffer laden und ggf. in die Wave-Datei uebertragen. 
\ So lange die Daten nicht in den Puffer passen, wird der Puffer
\ randvoll gefuellt und sodann in die Wave-Datei entleert.
\ Dann wird der Datenrest in den Puffer geladen.
: $>buf  ( addr len -- )
        BEGIN   bufsize bufcnt @ - >r
                dup r@ >=
        WHILE   over wbuffer bufcnt @ + r@ move
                swap r@ + swap  r> -
                wbuffer bufsize >file
                0 bufcnt !
        REPEAT  r> drop  dup
        IF      >r wbuffer bufcnt @ + r@ move
                bufcnt @ r> + bufcnt !
        ELSE    2drop
        THEN ;

\ 2 niederwertige Bytes vertauschen
: byte-swap  ( u1 -- u2 )  dup 8 rshift 255 and
                           swap 255 and 8 lshift or ;

\ 2-byte-Wert in den Schreibpuffer schreiben (big endian)
: 2>buf  ( u -- )  byte-swap  tmp !  tmp 2 $>buf ;


\ ##############################
\ Grafikdaten in Datei schreiben
\ ##############################

\ Dateibeginn
: _begin  ( -- )  cr ." begin "
        bufflush ;

\ Farbe waehlen
: _color  { r g b a -- }  ." color "
        $AA01 2>buf  r 2>buf  g 2>buf  b 2>buf  a 2>buf ;

\ Bildschirm loeschen
: _clear  ( -- )  ." clear "
        $AA02 2>buf ;

\ Gerade zeichnen
: _line  { x1 y1 x2 y2 -- }  ." line "
        $AA03 2>buf  x1 2>buf  y1 2>buf  x2 2>buf  y2 2>buf ;

\ Rechteck zeichnen (hohl oder gefuellt)
: _rect  { x y w h f -- }  ." rect "
        $AA04 2>buf  x 2>buf  y 2>buf  w 2>buf  h 2>buf  f 2>buf ;

\ Ellipse zeichnen (hohl oder gefuellt)
: _oval  { x y w h f -- }  ." oval "
        $AA05 2>buf  x 2>buf  y 2>buf  w 2>buf  h 2>buf  f 2>buf ;

\ Kreis zeichnen (hohl oder gefuellt)
: _circle  { x y r f -- }  ." circle "
        $AA06 2>buf  x 2>buf  y 2>buf  r 2>buf  f 2>buf ;

\ Ein oder mehrere Pixel setzen
: _plot-on   ( -- )   ." plot-on "    $AA07 2>buf ;
: _plot      { x y }  ." plot "  x 2>buf  y 2>buf ;
: _plot-off  ( -- )   ." plot-off "   $AA00 2>buf ;

\ Pause (Sekunden)
: _pause  { s -- }  ." pause "
        $AA08 2>buf  s 2>buf ;

\ Gesetzte Grafik sichtbar machen
: _show  ( -- )  ." show "
        $AA09 2>buf ;

\ Dateiende
: _end  ( -- )  ." end " cr cr
        $AA0A 2>buf  bufflush ;

\ Ellipsenbogen zeichnen (hohl oder gefuellt)
: _arc  { x y w h b a f }  ." arc "
        $AA0B 2>buf  x 2>buf  y 2>buf  w 2>buf  h 2>buf
                     b 2>buf  a 2>buf  f 2>buf ;

\ Tortenstueck zeichnen (hohl oder gefuellt)
: _pie  { x y w h b a f }  ." arc "
        $AA0C 2>buf  x 2>buf  y 2>buf  w 2>buf  h 2>buf
                     b 2>buf  a 2>buf  f 2>buf ;

\ Zeichensatz und Hoehe waehlen
: _font  { typ h }  ." font "
        $AA0D 2>buf  typ 2>buf  h 2>buf ;

\ Text einfuegen (big endian)
: _text-on   { x y }  ." text-on "
        $AA0E 2>buf  x 2>buf  y 2>buf ;
: _text      { abc }  ." text "        abc 2>buf ;
: _text-off  ( -- )   ." text-off "  $AA00 2>buf ;

\ Bezugsort waehlen
: _origin  { x y }  ." origin "
        $AA0F 2>buf  x 2>buf  y 2>buf ;

\ Nachfolgenden Plot drehen
: _rotate  { a }  ." rotate "
        $AA10 2>buf  a 2>buf ;

\ Rechteck mit runden Ecken zeichnen (hohl oder gefuellt)
: _rndrect  { x y w h r f }  ." rndrect "
        $AA11 2>buf  x 2>buf  y 2>buf  w 2>buf  h 2>buf
                     r 2>buf  f 2>buf ;

\ Dreieck zeichnen (hohl oder gefuellt)
: _triang  { x1 y1 x2 y2 x3 y3 f }  ." triang "
        $AA12 2>buf  x1 2>buf  y1 2>buf  x2 2>buf  y2 2>buf
                     x3 2>buf  y3 2>buf  f 2>buf ;

\ Grafikausrichtung speichern
: _save  ( -- )  ." save "
        $AA13 2>buf ;

\ Grafikausrichtung wiederherstellen
: _restore  ( -- )  ." restore "
        $AA14 2>buf ;


\ #######################
\ Eine Grafik formulieren
\ #######################

  create-wfile                    \ Ausgabe-Datei erzeugen

: go                                  _begin      \ Dateibeginn

    0    0    0  255                  _color      \ schwarz
                                      _clear      \ ausfuellen
  255  255  255  255                  _color      \ weiss

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  400  300  800  600              0   _rect       \ Rechteck
  400  300 1200  900                  _line       \ Diagonale
 1200  300  400  900                  _line       \ Diagonale

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  400  300  800  600              0   _oval       \ Ellipse

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  800  500  200                   0   _circle     \ Kreis

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  627  330  350  350  220  100    1   _pie        \ Torte

  100  100  100  255                  _color      \ grau

  400  300  800  600   45   90    1   _arc        \ Bogen

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  255  255  255  255                  _color      \ weiss

  350  250  900  700   50         0   _rndrect    \ runde Ecken

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

                                      _save       \ Drehrichtung
                                -10   _rotate     \ Drehung links

                                      _plot-on
  980 0 do i 200 + i s>f 30e f/ fsin 100e f* 770e f+ f>s
                                      _plot       \ Sinus
        loop                          _plot-off

                                      _restore    \ Drehung vergessen

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  100  100  100  255                  _color      \ grau

 1300  900 1700  500 1400  300    1   _triang     \ volles Dreieck

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  255  255  255  255                  _color      \ weiss

 1500  650 1600  460 1400  460    1   _triang     \ volles Dreieck

                                      _show       \ zeigen
                                  1   _pause      \ 1 Sekunde

  190  940                            _origin     \ neuer Bezugspunkt

                                -90   _rotate     \ Drehung links

                             3   70   _font       \ 3 = Serif 

  135  100                            _text-on    \ Text x y
       256 [char] H *  [char] e  +    _text       \ "Hello World "
       256 [char] l *  [char] l  +    _text
       256 [char] o *    bl      +    _text
       256 [char] W *  [char] o  +    _text
       256 [char] r *  [char] l  +    _text
       256 [char] d *    bl      +    _text
                                      _text-off

                                      _show       \ zeigen
                                100   _pause      \ 100 Sekunden

                                      _end ;      \ Dateiende

       go      \ Autostart
 