\ ===+=== 1 ===+=== 2 ===+=== 3 ===+=== 4 ===+=== 5 ===+=== 6 ===+===
\ plotter.fs - last edit: 19-feb-2014 21:00 -jgt
\
\ ###################################################################
\ Generieren einer durch Mobile Basic zu interpretierenden Plot-Datei
\ ###################################################################
\
\ Fuer die Grafik-Datei sind (vorerst nur) 10 Befehle vorgesehen, mit
\ denen in beliebigen Farben Linien, Kreise, Ellipsen, Rechtecke und
\ vor allem einzelne Pixel gesetzt werden koennen. Die Befehle werden
\ jeweils durch Kennnummern eingeleitet. Kennummern und Parameter
\ haben 16 bit Breite (Bytes-Anordnung: big endian). Fuer den Befehl
\ plot sind als Parameter beliebig viele xy-Paare erlaubt, die durch
\ eine Ende-Kennung abgeschlossen werden. clear fuellt den Bild-
\ schirm mit vorgewaehlter Farbe, show macht die gesetzte Grafik
\ sichtbar.
\
\   "_color"    | $AA01 |  <r>  |  <g>  |  <b>  |  <a>  |
\   "_clear"    | $AA02 |
\   "_line"     | $AA03 |  <x1> |  <y1> |  <x2> |  <y2> |
\   "_rect"     | $AA04 |  <x>  |  <y>  |  <w>  |  <h>  |  <f>  |
\   "_oval"     | $AA05 |  <x>  |  <y>  |  <w>  |  <h>  |  <f>  |
\   "_circle"   | $AA06 |  <x>  |  <y>  |  <r>  |  <f>  |
\   "_plot"     | $AA07 |  <x1> |  <y1> | . . . | . . . | $AA00 |
\   "_pause"    | $AA08 |  <s>  |
\   "_show"     | $AA09 |
\   "_end"      | $AA0A |
\ 
\ <r><g><b> = rot gruen blau (0 0 0 = schwarz, 255 255 255 = weiss)
\ <a> = alpha (0 = transparent, 255 = deckend)
\ <x><y><r> = Kreismittelpunkt und -radius
\ <x><y> = linke obere Ecke (Rechteck und Rahmen fuer Ellipse)
\ <w><h> = Breite und Hoehe (Rechteck und Rahmen fuer Ellipse)
\ <f> = ausfuellen (true/false fuer Kreis, Ellipse und Rechteck)
\ <s> = Sekunden (fuer Pause)

  s" deskplot.dat" 2constant  wfile       \ Dateiname
  0                value      wfileID     \ Dateikennung
  2000             constant   bufsize     \ Puffergroesse
                   variable   bufcnt      \ Pufferzaehler
                   variable   tmp         \ Fluechtige Variable

create wbuffer bufsize allot              \ Schreibpuffer

\ Ausgabedatei erzeugen 
: create-wfile  ( --)
            wfile R/W BIN  ( c-addr u fam)
            CREATE-FILE      ( fileid ior)
      IF    ." couldn't create " wfile type ."  - quit" quit
      THEN  to wfileID ;

\ Daten in Wave-Datei schreiben.
: >file  ( addr len)  wfileID  WRITE-FILE ( ior) drop ;

\ Schreibpuffer leeren und in Datei schreiben.
\ FLUSH-FILE leert auch den unsichtbaren Zwischenspeicher.
\ Am Programmende ist der Puffer mit bufflush zu leeren.
: bufflush  ( --)
            wbuffer bufcnt @ >file
            0 bufcnt !
            wfileID FLUSH-FILE drop ;

\ Schreibpuffer laden und ggf. in die Wave-Datei uebertragen. 
\ So lange die Daten nicht in den Puffer passen, wird der Puffer
\ randvoll gefuellt und sodann in die Wave-Datei entleert.
\ Dann wird der Datenrest in den Puffer geladen.
: $>buf  ( addr len --)
        BEGIN   bufsize bufcnt @ - >r
                dup r@ >=
        WHILE   over wbuffer bufcnt @ + r@ move
                swap r@ + swap  r> -
                wbuffer bufsize >file
                0 bufcnt !
        REPEAT  r> drop  dup
        IF      >r wbuffer bufcnt @ + r@ move
                bufcnt @ r> + bufcnt !
        ELSE    2drop
        THEN ;

\ 2 niederwertige Bytes vertauschen
: byte-swap  ( u1 -- u2 )  dup 8 rshift 255 and
                           swap 255 and 8 lshift or ;

\ 2-byte-Wert in den Schreibpuffer schreiben.(big endian)
: 2>buf  ( u --)  byte-swap  tmp !  tmp 2 $>buf ;


\ ##############################
\ Grafikdaten in Datei schreiben
\ ##############################

\ Dateibeginn
: _begin  ( -- )  cr ." begin "
        bufflush ;

\ Farbe waehlen
: _color  { r g b a -- }  ." color "
        $AA01 2>buf  r 2>buf  g 2>buf  b 2>buf  a 2>buf ;

\ Bildschirm loeschen
: _clear  ( -- )  ." clear "
        $AA02 2>buf ;

\ Gerade zeichnen
: _line  { x1 y1 x2 y2 -- )  ." line "
        $AA03 2>buf  x1 2>buf  y1 2>buf  x2 2>buf  y2 2>buf ;

\ Rechteck zeichnen (hohl oder gefuellt)
: _rect  { x y w h f -- }  ." rect "
        $AA04 2>buf  x 2>buf  y 2>buf  w 2>buf  h 2>buf  f 2>buf ;

\ Ellipse zeichnen (hohl oder gefuellt)
: _oval  { x y w h f -- }  ." oval "
        $AA05 2>buf  x 2>buf  y 2>buf  w 2>buf  h 2>buf  f 2>buf ;

\ Kreis zeichnen (hohl oder gefuellt)
: _circle  { x y r f -- }  ." circle "
        $AA06 2>buf  x 2>buf  y 2>buf  r 2>buf  f 2>buf ;

\ Ein oder mehrere Pixel setzen
: _plot-on   ( -- )        $AA07 2>buf  ." plot-on " ;
: _plot      { x y }  x 2>buf  y 2>buf  ." plot " ;
: _plot-off  ( -- )        $AA00 2>buf  ." plot-off " ;

\ Pause (Sekunden)
: _pause  { s -- }  ." pause "
        $AA08 2>buf  s 2>buf ;

\ Gesetzte Grafik sichtbar machen
: _show  ( -- )  ." show "
        $AA09 2>buf ;

\ Dateiende
: _end  ( -- )  ." end " cr cr
        $AA0A 2>buf  bufflush ;


\ #######################
\ Eine Grafik formulieren
\ #######################

  create-wfile                    \ Ausgabe-Datei erzeugen

: go   bufflush
                        _begin      \ Dateibeginn
    0   0   0 255       _color      \ schwarz deckend
                        _clear      \ Bildschirm fuellen
  255 255 255 255       _color      \ weiss deckend
  400 300 800 600   0   _rect       \ Rechteck
  400 300 800 600   0   _oval       \ Ellipsen
  800 500 200   0       _circle     \ Kreis
                        _show       \ Grafik aktualisieren
                    2   _pause      \ Pause 2 Sekunden
  700 400 200 100   1   _oval       \ Ellipse ausgefuellt
  255  40  40 127       _color      \ 
  750 410 100  80   1   _oval       \ Ellipse ausgefuellt
                        _show       \ Grafik aktualisieren
                    2   _pause      \ Pause 2 Sekunden
  255 180 180 255       _color      \ Rot fuer Plot
                        _plot-on    \ Plot
  1200 0 do i 200 + i s>f 30e f/ fsin 100e f* 800e f+ f>s
                        _plot       \ Sinuskurve
         loop           _plot-off
                        _show       \ Grafik aktualisieren
                   10   _pause      \ Pause 10 Sekunden
                        _end ;      \ Dateiende

  go    \ Autostart

\ ===================================================================

