\ ====== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ==|
\ WAVER3-03.fs - last edit: 17-nov-2013 15:10 -jgt
\               _____________________________________
\              |                                     |
\              |        W a v e   E n g i n e        |   ============
\              |                                     |   Gforth 0.7.0
\              |            Version 3-03             |   ============
\              |_____________________________________|
\
\ Praeambel:  Nachdem die komplexe, aber recht ordenlich laufende zweite
\ Version des Synthesizers "Wave Engine" durch ein Linux-Update instabil
\ geworden war, reifte der Entschluss, eine dritte Version (3-xx) neu zu
\ beginnen und dabei allen Code zugaenglich zu machen.
\
\ Version 3-01 lieferte einstimmige Sinustoene. Version 3-02 war vier-
\ stimmig mit Abklingen. Es ertoenten vier Akkorde, die von einem
\ stoerenden Rauschen begleitet waren. Dieses Rauschen wurde in dieser
\ Version 3-03 beseitigt. (Kommentiert in VD 4/2013.)
 

\ Konstanten fuer den Wave-Generator
      true   constant  mono          \ false: 2 Kanaele (mit/ohne Stereo)
      false  constant  stereo        \ true: Raumklang (mono = false)
      false  constant  prelist       \ true: Text vor (statt nach) Daten

    s" WAVER3-03"      2constant  version   \ Versionsbezeichnung
    s" WE-001.wav"     2constant  wavefile  \ Name der Ausgabedatei

    s" goodies.fs"     included             \ Zweibytebefehle, f+! etc.
    s" freqtab-1.fs"   included             \ Frequenztabelle
    s" wavgen.fs"      included             \ Wave-Generator
    s" partitur.fs"    included             \ Notenblatt
    s" singen-2.fs"    included  cr cr      \ Sinus-Generator

\ ------------------------------------------------------------------------

\ Wave-Daten in dataChunk einfuegen (an Kopf anhaengen)
: append-data  ( --)
        4 ( 0000) nulls                     \ Pause vorab
              bytecnt @
           16 align-nulls                   \ Pausenende justieren
              waves                         \ Wave-Daten schreiben
              bytecnt @ 4 -                 \ 4 Pos. nach rechts
           16 align-nulls                   \ 0...15 Null-Bytes
              bytecnt @ dataend ! ;         \ Chunk-Ende merken

\ Text in listChunk einfuegen (an Kopf anhaengen)
: append-text  ( --)
              s"   [ "              $>buf
              s" Wave Engine 3.03"  $>buf
              s" edit 131110-1710"  $>buf   \ editiert: ...
              s" comp "             $>buf   \ compiliert: ...
              timestamp                     \ aktuelles Datum
              s"  ]"                $>buf   \ Text-Ende
                                            \ Leerzeichen anhaengen
              bytecnt @  4 -                \ 4 Pos. nach rechts
           16 align-spaces                  \ 0...15 Leerzeichen
              bytecnt @ listend ! ;         \ Chunk-Ende merken

: init  ( --) ;

\ ------------------------------------------------------------------------

\                      H A U P T - R O U T I N E

: build-wavefile  ( --)
                    init
                    create-outfile          \ Wave-Datei anlegen
                    build-waveChunk         \ erste 12 Bytes
                    build-formatChunk       \ weitere 24 Bytes
     prelist IF
                    build-listChunk         \ listChunk ohne Text
                      append-text           \ Text anhaengen
                    build-dataChunk         \ dataChunk ohne Daten
                      append-data           \ Wave-Daten anhaengen
             ELSE
                    build-dataChunk         \ dataChunk ohne Daten
                      append-data           \ Wave-Daten anhaengen
                    build-listChunk         \ listChunk ohne Text
                      append-text           \ Text anhaengen
             ENDIF
                    patch-waveChunkSize     \ Laenge ueber alles
                    patch-dataChunkSize     \ Laenge dataChunk
                    patch-listChunkSize     \ Laenge listChunk
                    fillup                  \ Fuellbytes
                    close-outfile ;         \ Wave-Datei schlieszen

\                              S T A R T
: go  build-wavefile
           ."  fertig! " .s f.s  cr ;       \ "<0> <0>" = Stacks okay

    version  type  ."    >>>--->  Mit 'go' starten!  <---<<< " cr cr

\ =======[ Ende von WAVER3-03.fs ]========================================

