\ ====== 1 ======= 2 ======= 3 ======= 4 ======= 5 ======= 6 ======= 7 ==|
\ singen-2.fs - last edit: 17-nov-2013 15:00 -jgt
  cr ." included: singen-2.fs"
\
\ ------------------------------------------------------------------------

\ | 0xxx xxxx xxxx xxxx |   Tondauer (1 bis 28800 = 10 Takte)
\ | 10mm sssx xxxx xxxx |   Pitch (max 109) (mm/sss = Manual/Stimme)
\ | 10mm sss0 0000 0000 |   Pause
\ | 10mm sss1 1111 1111 |   Fortklingen

        2  constant   #manuals      \ Anzahl Manuale
        2  constant   #voices       \ Anzahl Stimmen pro Manual
        2  constant   #partials     \ Anzahl Teiltoene pro Stimme
   .9999e  fconstant  damp          \ Daempfung (Ablkingen)
  
        0  value      manu#         \ Manual #
        0  value      lvox#         \ Stimme # lokal
        0  value      gvox#         \ Stimme # global
        0  value      lpart#        \ Teilton # lokal
        0  value      gpart#        \ Teilton # global
        0  value      durat         \ Tondauer	
        0  value      habit         \ Anzahl Stimmen (not used)

           fvariable  accu          \ Sinuswerte aufaddieren
\ ------------------------------------------------------------------------

\ Tabelle der Float-Werte, jedem Teilton zugeordnet.
\ 2 Manuale, 4 Stimmen, 8 Teiltoene (kuenftig 4 Manuale, 24 Stimmen).
\ je Teilton (floating) Phase (p), Phasenschritt (s), Huellkurve (e).
\
create gtable  #manuals #voices #partials 24 * * * allot
\
\     -------------------------------------------------
\     |                    manual-A                   |
\     |         voice1        |         voice2        |   p = phase
\     |   part1   |   part2   |   part1   |   part2   |   s = step
\     | p | s | e | p | s | e | p | s | e | p | s | e |   e = envelope
\     -------------------------------------------------
\       0   8  16  24  32  40  48  56  64  72  80  88 (96)
\     -------------------------------------------------
\     |                    manual-B                   |
\     |         voice1        |         voice2        |
\     |   part1   |   part2   |   part1   |   part2   |
\     | p | s | e | p | s | e | p | s | e | p | s | e |
\     -------------------------------------------------
\      96 104 112 120 128 136 144 152 160 168 176 184 (192)
\ ------------------------------------------------------------------------

\ Sinus-Stuetzpunkte berechnen
\ Erster Aufruf: Timer gesetzt, Phase=0, Phasenschritt gesetzt.
\ Der Sinuswert (max. plus/minus 1) mal "volume" wird aufaddiert.
\ Die Phase wird um den Phasenschritt erhoeht.
\
: generate  ( --)
    gpart# 24 * gtable + dup f@ fsin            \ Sinuswert aus Phase
                         dup 16 + f@ f*         \ Sinuswert mal Huellkurve
                             accu f+!           \ auf Akku aufaddieren
                         dup  8 + f@			\ Phasenschritt
                         dup      f+!           \ auf Phase aufaddieren
                    16 + dup f@  damp f* f! ;   \ Huellkurve daempfen
   
\ ------------------------------------------------------------------------

: >voice  ( voice manual -- gvoice)             \ Stimmen-Nummer
    #voices * + ;

: >partial  ( partial voice manual -- gpart)    \ Teilton-Nummer
    >voice  #partials * + ; 

: >mpart  ( partial manual -- mpart)            \ Teilton eines Manuals
    #partials * + ;

\ Schleifen fuer Manuale, Stimmen und Teilstimmen
\ Fuer jede Teilstimme wird ein Kurvenpunkt berechnet.
\
: loops  ( --)
    durat 2* 0                                      \ Tondauer (17 bit)
    ?DO
        0e accu f!                                  \ Akku leeren
        #manuals 0
        ?DO  i                         to manu#     \ Manual-Nummer
            #voices 0
            ?DO  i                     to lvox#     \ Stimmen-Nummer
                i j          >voice    to gvox#     \ dito fortlaufend
                #partials 0
                ?DO  i                 to lpart#    \ Teilton-Nummer
                    i j k    >partial  to gpart#    \ dito fortlaufend
                    generate                        \ Teilton bearbeiten
                LOOP
            LOOP
        LOOP
        accu f@ .5e f+ f>s w>buf                    \ in die Wave-Datei
    LOOP ;

\ ------------------------------------------------------------------------

\ Stimmen laden (Phase, Step, Envelope fuer Grund- und 2. Oberton)
\ Volle Amplitude: envelope = 32767e maximal (bei nur einer Stimme)
: >A1  ( u --)           0e gtable       f!     0e gtable  24 + f!
             fadr12 f@ fdup gtable   8 + f!  2e f* gtable  32 + f!
                      5000e gtable  16 + f!   1000e gtable  40 + f! ;

: >A2  ( u --)           0e gtable  48 + f!     0e gtable  72 + f!
             fadr12 f@ fdup gtable  56 + f!  2e f* gtable  80 + f!
                      5000e gtable  64 + f!   1000e gtable  88 + f! ;

: >B1  ( u --)           0e gtable  96 + f!     0e gtable 120 + f!
             fadr12 f@ fdup gtable 104 + f!  2e f* gtable 128 + f!
                      5000e gtable 112 + f!   1000e gtable 136 + f! ;

: >B2  ( u --)           0e gtable 144 + f!     0e gtable 168 + f!
             fadr12 f@ fdup gtable 152 + f!  2e f* gtable 176 + f!
                      5000e gtable 160 + f!   1000e gtable 184 + f! ;


\ Partiturschleife: Akkord fuer Akkord
\ Phase=0, Timer und Tonhoehen laden, Generator starten
: waves  ( --)
    tunelen 0                       \ Partiturlaenge (Akkordzeilen)
    ?DO
        tune i 12 * +               \ 10 Bytes (2 Tondauer, 4*2 Tonhoehe)
        dup      uw@  to durat      \ Tondauer
        dup  2 + uw@  to habit      \ 4 => 4 Werte folgen (not used)
        dup  4 + uw@  >A1           \ Manual A. Stimme 1
        dup  6 + uw@  >A2           \ Manual A, Stimme 2
        dup  8 + uw@  >B1           \ Manual B, Stimme 1
            10 + uw@  >B2           \ Manual B, Stimme 2
        loops
    LOOP ;

\ =======[ Ende von singen-2.fs ]=========================================
