;
;
;M38002 definitions
; SFR
P0        =0
P0D       =1
P1        =2
P1D       =3
P2        =4
P2D       =5
P3        =6
P3D       =7
P4        =8
P4D       =9
P5        =$0A
P5D       =$0B
P6        =$0C
P6D       =$0D
P7        =$0E
P7D       =$0F

TBRB      =$18
SIOSTS    =$19
SIOCON    =$1A
UARTCON   =$1B
BRG       =$1C

PRE12     =$20
T1        =$21
T2        =$22
TM        =$23
PREX      =$24
TX        =$25
PREY      =$26
TY        =$27

INTEDGE   =$3A
CPUM      =$3B
IREQ1     =$3C
IREQ2     =$3D
ICON1     =$3E
ICON2     =$3F




; memory map 
; 00..03f   SFR
; 40..09E   Data stack
; N
; IP
; W
; UP
; xsave

; 0100..01BF  Returnstack
;
; 0500        Userpage
;0A    TIB
;0C    WIDTH
;0E    WARNING
;10    FENCE
;12    DP
;14    VOC-LINK
;16    BLK
;18    IN
;1A    OUT
;1C    SCR
;1E    OFFSET
;20    CONTEXT
;22    CURRENT
;24    STATE
;26    BASE
;28    DPL
;2A    FLD
;2C    CSP
;2E    R#
;30    HLD



; 0600        TIB

; buffers

; 1000
; 2000        vocabular

; 8000..      rom        
; FFC0..FFFF  intvect








; Forth memory


SSIZE     =128           ; sector size in bytes
NBUF      =8             ; number of buffers desired in RAM
;                             (SSIZE*NBUF >= 1024 bytes)
SECTR     =800           ; sector per drive
;                              forcing high drive to zero
SECTL     =1600          ; sector limit for two drives
;                              of 800 per drive.
BMAG      =1056          ; total buffer magnitude, in bytes
;                              expressed by SSIZE+4*NBUF
;
BOS       =$40           ; bottom of data stack, in zero-page.
TOS       =$9E           ; top of data stack, in zero-page.
N         =TOS+8         ; scratch workspace.
IP        =N+8           ; interpretive pointer.
W         =IP+3          ; code field pointer.

UP        =W+2           ; user area pointer.
XSAVE     =UP+2          ; temporary for X register.
;
TIBX      =$0100         ; terminal input buffer of 84 bytes.
ORIG      =$8000         ; origin of FORTH"s Dictionary.
MEM       =$1000         ; top of assigned memory+1 byte.
UAREA     =MEM-128       ; 128 bytes of user area
DAREA     =UAREA-BMAG    ; disk buffer space.
INITDP    =$2000         ; Startadresse Ram DP 
;
;         Monitor calls for terminal support
;
;
;    From DAREA downward to the top of the dictionary is free
;    space where the user"s applications are compiled.
;
;    Boot up parameters. This area provides jump vectors
;    to Boot up  code, and parameters describing the system.
;
;
          *=ORIG
;
                         ; User cold entry point
ENTER     NOP            ; Vector to COLD entry
          JMP COLD+2     ;
REENTR    NOP            ; User Warm entry point
          JMP WARM       ; Vector to WARM entry
          .WORD $0004    ; 6502 in radix-36
          .WORD $5ED2    ;
          .WORD L2347-INITV+INITDP   ; Name address of TASK
          .WORD $7F      ; Backspace Character
          .WORD UAREA    ; Initial User Area
          .WORD TOS      ; Initial Top of Stack
          .WORD $1BF     ; Initial Top of Return Stack
          .WORD TIBX     ; Initial terminal input buffer
;
;
          .WORD 31       ; Initial name field width
          .WORD 0        ; 0=nod disk, 1=disk
          .WORD TOP      ; Initial fence address
          .WORD INITVEND-INITV+INITDP ;Forth+Task  ; Initial top of dictionary
          .WORD VL0-INITV+INITDP     ; Initial Vocabulary link ptr.

; jetzt die Worte fr RAM
INITV
;
;                                       FORTH
;                                       SCREEN 53 LINE 9
;
L2346     .BYTE $C5,"FORT",$C8
          .WORD NTOP     ; link to NTOP Mon
          .WORD *+4
FORTH     .WORD DODOE
          .WORD DOVOC
          .WORD $A081
XFOR      .WORD L2347-INITV+INITDP    ; points to top name in FORTH
VL0       .WORD 0        ; last vocab link ends at zero
;
L2347     .BYTE $84,"TAS",$CB
TASK      .WORD L2346-INITV+INITDP    ; link to Forth
          .WORD *+4
          .WORD DOCOL
          .WORD SEMIS
INITVEND

;
;    The following offset adjusts all code fields to avoid an
;    address ending $XXFF. This must be checked and altered on
;    any alteration , for the indirect jump at W-1 to operate !
;
          .ORG *+2
;
;
;                                       LIT
;                                       SCREEN 13 LINE 1
;
L22       .BYTE $83,"LI",$D4            ; <--- name field
;                          <----- link field
          .WORD 00       ; last link marked by zero
          .WORD *+4      ; <----- pfapointer
LIT       .WORD *+2      ; <----- code address field
          LDA (IP),Y     ; <----- start of parameter field
          PHA
          INC IP
          BNE L30
          INC IP+1
L30       LDA (IP),Y
L31       INC IP
          BNE PUSH
          INC IP+1
;
PUSH      DEX
          DEX
;
PUT       STA 1,X
          PLA
          STA 0,X
;
;    NEXT is the address interpreter that moves from machine
;    level word to word.
;
NEXT      LDY #1
          LDA (IP),Y     ; Fetch code field address pointed
          STA W+1        ; to by IP.
          DEY
          LDA (IP),Y
          STA W

          CLC            ; Increment IP by two.
          LDA IP
          ADC #2
          STA IP
          BCC L54
          INC IP+1
L54       JMP W-1        ; Jump to an indirect jump (W) which
;                        vectors to code pointed to by a code
;                        field.
;
;    CLIT pushes the next inline byte to data stack
;
L35       .BYTE $84,"CLI",$D4
          .WORD L22      ; Link to LIT
          .WORD *+4
CLIT      .WORD *+2
          LDA (IP),Y
          PHA
          TYA
          BEQ L31        ; a forced branch into LIT
;
;
;
;
SETUP     ASL A
          STA N-1
L63       LDA 0,X
          STA N,Y
          INX
          INY
          CPY N-1
          BNE L63
          LDY #0
          RTS
;
;                                       EXCECUTE
;                                       SCREEN 14 LINE 11
;
L75       .BYTE $87,"EXECUT",$C5
          .WORD L35      ; link to CLIT
          .WORD *+4
EXEC      .WORD *+2
          LDA 0,X
          STA W
          LDA 1,X
          STA W+1
          INX
          INX
          JMP W-1        ; to JMP (W) in z-page
;
;                                       BRANCH
;                                       SCREEN 15 LINE 11
;
L89       .BYTE $86,"BRANC",$C8
          .WORD L75      ; link to EXCECUTE
          .WORD *+4
BRAN      .WORD *+2
          CLC
          LDA (IP),Y
          ADC IP
          PHA
          INY
          LDA (IP),Y
          ADC IP+1
          STA IP+1
          PLA
          STA IP
          JMP NEXT +2
;
;                                       0BRANCH
;                                       SCREEN 15 LINE 6
;
L107      .BYTE $87,"0BRANC",$C8
          .WORD L89      ; link to BRANCH
          .WORD *+4
ZBRAN     .WORD *+2
          INX
          INX
          LDA $FE,X
          ORA $FF,X
          BEQ BRAN+2
;
BUMP      CLC
          LDA IP
          ADC #2
          STA IP
          BCC L122
          INC IP+1
L122      JMP NEXT
;
;                                       (LOOP)
;                                       SCREEN 16 LINE 1
;
L127      .BYTE $86,"(LOOP",$A9
          .WORD L107     ; link to 0BRANCH
          .WORD *+4
PLOOP     .WORD L130
L130      STX  XSAVE
          TSX
          INC $101,X
          BNE PL1
          INC $102,X
;
PL1       CLC
          LDA $103,X
          SBC $101,X
          LDA $104,X
          SBC $102,X
;
PL2       LDX XSAVE
          ASL A
          BCC BRAN+2
          PLA
          PLA
          PLA
          PLA
          JMP BUMP
;
;                                       (+LOOP)
;                                       SCREEN 16 LINE 8
;
L154      .BYTE $87,"(+LOOP",$A9
          .WORD L127     ; link to (loop)
          .WORD *+4
PPLOO     .WORD *+2
          INX
          INX
          STX XSAVE
          LDA $FF,X
          PHA
          PHA
          LDA $FE,X
          TSX
          INX
          INX
          CLC
          ADC $101,X
          STA $101,X
          PLA
          ADC $102,X
          STA $102,X
          PLA
          BPL PL1
          CLC
          LDA $101,X
          SBC $103,X
          LDA $102,X
          SBC $104,X
          JMP PL2
;
;                                       (DO)
;                                       SCREEN 17 LINE 2
;
L185      .BYTE $84,"(DO",$A9
          .WORD L154     ; link to (+LOOP)
          .WORD *+4
PDO       .WORD *+2
          LDA 3,X
          PHA
          LDA 2,X
          PHA
          LDA 1,X
          PHA
          LDA 0,X
          PHA
;
POPTWO    INX
          INX
;
;
;
POP       INX
          INX
          JMP NEXT
;
;                                       I
;                                       SCREEN 17 LINE 9
;
L207      .BYTE $81,$C9
          .WORD L185     ; link to (DO)
          .WORD *+4
I         .WORD R+2      ; share the code for R
;
;                                       DIGIT
;                                       SCREEN 18 LINE 1
;
L214      .BYTE $85,"DIGI",$D4
          .WORD L207     ; link to I
          .WORD *+4
DIGIT     .WORD *+2
          SEC
          LDA 2,X
          SBC #$30
          BMI L234
          CMP #$A
          BMI L227
          SEC
          SBC #7
          CMP #$A
          BMI L234
L227      CMP 0,X
          BPL L234
          STA 2,X
          LDA #1
          PHA
          TYA
          JMP PUT        ; exit true with converted value
L234      TYA
          PHA
          INX
          INX
          JMP PUT        ; exit false with bad conversion
;
;                                       (FIND)      ( textadr nfa --- pfa byte tf) ok
;                                                   ( textadr nfa --- ff ) not found
;                                       SCREEN 19 LINE 1
;
L243      .BYTE $86,"(FIND",$A9
          .WORD L214   ; Link to DIGIT
          .WORD *+4
PFIND     .WORD *+2
          LDA #2
          JSR SETUP
          STX XSAVE
L249      LDY #0
          LDA (N),Y
          EOR (N+2),Y
;
;
          AND #$3F
          BNE L281
L254      INY
          LDA (N),Y
          EOR (N+2),Y
          ASL A
          BNE L280
          BCC L254
          LDX XSAVE
          DEX
          DEX
          DEX
          DEX
          CLC
          TYA
          ADC #3       ; rsc sonst 5
          ADC N
          STA 2,X
          LDY #0
          TYA
          ADC N+1
          STA 3,X
          STY 1,X
          LDA (N),Y
          STA 0,X
          LDA #1
          PHA
          JMP PUSH
L280      BCS L284
L281      INY
          LDA (N),Y
          BPL L281
L284      INY
          LDA (N),Y
          TAX
          INY
          LDA (N),Y
          STA N+1
          STX N
          ORA N
          BNE L249
          LDX XSAVE
          LDA #0
          PHA
          JMP PUSH       ; exit false upon reading null link
;
;                                       ENCLOSE
;                                       SCREEN 20 LINE 1
;
L301      .BYTE $87,"ENCLOS",$C5
          .WORD L243     ; link to (FIND)
          .WORD *+4
ENCL      .WORD *+2
          LDA #2
          JSR SETUP
          TXA
          SEC
          SBC #8
          TAX
          STY 3,X
          STY 1,X
          DEY
L313      INY
          LDA (N+2),Y
          CMP N
          BEQ L313
          STY 4,X
L318      LDA (N+2),Y
          BNE L327
          STY 2,X
          STY 0,X
          TYA
          CMP 4,X
          BNE L326
          INC 2,X
L326      JMP NEXT
L327      STY 2,X
          INY
          CMP N
          BNE L318
          STY 0,X
          JMP NEXT
;
;                                       EMIT
;                                       SCREEN 21 LINE 5
;
L337      .BYTE $84,"EMI",$D4
          .WORD L301     ; link to ENCLOSE
          .WORD *+4
EMIT      .WORD XEMIT    ; Vector to code for KEY
;
;                                       KEY
;                                       SCREEN 21 LINE 7
;
L344      .BYTE $83,"KE",$D9
          .WORD L337     ; link to EMIT
          .WORD *+4
KEY       .WORD XKEY     ; Vector to code for KEY
;
;                                       ?TERMINAL
;                                       SCREEN 21 LINE 9
;
L351      .BYTE $89,"?TERMINA",$CC
          .WORD L344     ; link to KEY
          .WORD *+4
QTERM     .WORD XQTER    ; Vector to code for ?TERMINAL
;
;
;
;
;
;                                       CR
;                                       SCREEN 21 LINE 11
;
L358      .BYTE $82,"C",$D2
          .WORD L351     ; link to ?TERMINAL
          .WORD *+4
CR        .WORD XCR      ; Vector to code for CR
;
;                                       CMOVE
;                                       SCREEN 22 LINE 1
;
L365      .BYTE $85,"CMOV",$C5
          .WORD L358     ; link to CR
          .WORD *+4
CMOVE     .WORD *+2
          LDA #3
          JSR SETUP
L370      CPY N
          BNE L375
          DEC N+1
          BPL L375
          JMP NEXT
L375      LDA (N+4),Y
          STA (N+2),Y
          INY
          BNE L370
          INC N+5
          INC N+3
          JMP L370
;
;                                       U*
;                                       SCREEN 23 LINE 1
;
L386      .BYTE $82,"U",$AA
          .WORD L365     ; link to CMOVE
          .WORD *+4
USTAR     .WORD *+2
          LDA 2,X
          STA N
          STY 2,X
          LDA 3,X
          STA N+1
          STY 3,X
          LDY #16        ; for 16 bits
L396      ASL 2,X
          ROL 3,X
          ROL 0,X
          ROL 1,X
          BCC L411
          CLC
          LDA N
          ADC 2,X
          STA 2,X
          LDA N+1
          ADC 3,X
          STA 3,X
          LDA #0
          ADC 0,X
          STA 0,X

L411      DEY
          BNE L396
          JMP NEXT
;
;                                       U/
;                                       SCREEN 24 LINE 1
;
L418      .BYTE $82,"U",$AF
          .WORD L386     ; link to U*
          .WORD *+4
USLAS     .WORD *+2
          LDA 4,X
          LDY 2,X
          STY 4,X
          ASL A
          STA 2,X
          LDA 5,X
          LDY 3,X
          STY 5,X
          ROL A
          STA 3,X
          LDA #16
          STA N
L433      ROL 4,X
          ROL 5,X
          SEC
          LDA 4,X
          SBC 0,X
          TAY
          LDA 5,X
          SBC 1,X
          BCC L444
          STY 4,X
          STA 5,X
L444      ROL 2,X
          ROL 3,X
          DEC N
          BNE L433
          JMP POP
;
;                                       AND
;                                       SCREEN 25 LINE 2
;
L453      .BYTE $83,"AN",$C4
          .WORD L418     ; link to U/
          .WORD *+4
ANDD      .WORD *+2
          LDA 0,X
          AND 2,X
          PHA
          LDA 1,X
          AND 3,X
;
BINARY    INX
          INX
          JMP PUT
;
;                                       OR
;                                       SCREEN 25 LINE 7
;
L469      .BYTE $82,"O",$D2
          .WORD L453     ; link to AND
          .WORD *+4
OR        .WORD *+2
          LDA 0,X
          ORA 2,X
          PHA
          LDA 1,X
          ORA 3,X
          INX
          INX
          JMP PUT
;
;                                       XOR
;                                       SCREEN 25 LINE 11
;
L484      .BYTE $83,"XO",$D2
          .WORD L469     ; link to OR
          .WORD *+4
XOR       .WORD *+2
          LDA 0,X
          EOR 2,X
          PHA
          LDA 1,X
          EOR 3,X
          INX
          INX
          JMP PUT
;
;                                       SP@
;                                       SCREEN 26 LINE 1
;
L499      .BYTE $83,"SP",$C0
          .WORD L484     ; link  to XOR
          .WORD *+4
SPAT      .WORD *+2
          TXA
;
PUSHOA    PHA
          LDA #0
          JMP PUSH
;
;                                       SP!
;                                       SCREEN 26 LINE 5
;
;
L511      .BYTE $83,"SP",$A1
          .WORD L499     ; link to SP@
          .WORD *+4
SPSTO     .WORD *+2
          LDY #6
          LDA (UP),Y     ; load data stack pointer (X reg) from
          TAX            ; silent user variable S0.
          JMP NEXT
;
;                                       RP!
;                                       SCREEN 26 LINE 8
;
L522      .BYTE $83,"RP",$A1
          .WORD L511     ; link to SP!
          .WORD *+4
RPSTO     .WORD *+2
          STX XSAVE      ; load return stack pointer (machine
          LDY #8         ; stack pointer) from silent user
          LDA (UP),Y     ; VARIABLE R0
          TAX
          TXS
          LDX XSAVE
          JMP NEXT
;
;                                       ;S
;                                       SCREEN 26 LINE 12
;
L536      .BYTE $82,";",$D3
          .WORD L522     ; link to RP!
          .WORD *+4
SEMIS     .WORD *+2
          PLA
          STA IP
          PLA
          STA IP+1
          JMP NEXT
;
;                                       LEAVE
;                                       SCREEN 27 LINE  1
;
L548      .BYTE $85,"LEAV",$C5
          .WORD L536     ; link to ;S
          .WORD *+4
LEAVE     .WORD *+2
          STX XSAVE
          TSX
          LDA $101,X
          STA $103,X
          LDA $102,X
          STA $104,X
          LDX XSAVE
          JMP NEXT
;
;                                       >R
;                                       SCREEN 27 LINE 5
;
L563      .BYTE $82,">",$D2
          .WORD L548     ; link to LEAVE
          .WORD *+4
TOR       .WORD *+2
          LDA 1,X        ; move high byte
          PHA
          LDA 0,X        ; then low byte
          PHA            ; to return stack
          INX
          INX            ; popping off data stack
          JMP NEXT
;
;                                       R>
;                                       SCREEN 27 LINE 8
;
L577      .BYTE $82,"R",$BE
          .WORD L563     ; link to >R
          .WORD *+4
RFROM     .WORD *+2
          DEX            ; make room on data stack
          DEX
          PLA            ; high byte
          STA 0,X
          PLA            ; then low byte
          STA 1,X        ; restored to data stack
          JMP NEXT
;
;                                       R
;                                       SCREEN 27 LINE 11
;
L591      .BYTE $81,$D2
          .WORD L577     ; link to R>
          .WORD *+4
R         .WORD *+2
          STX XSAVE
          TSX            ; address return stack
          LDA $101,X     ; copy bottom value
          PHA            ; to data stack
          LDA $102,X
          LDX XSAVE
          JMP PUSH
;
;                                       0=
;                                       SCREEN 28 LINE 2
;
L605      .BYTE $82,"0",$BD
          .WORD L591     ; link to R
          .WORD *+4
ZEQU      .WORD *+2
          LDA 1,X        ; Corrected from FD3/2 p69
          STY 1,X
          ORA 0,X
          BNE L613
          INY
L613      STY 0,X
          JMP NEXT
;
;                                       0<
;                                       SCREEN 28 LINE 6
;
L619      .BYTE $82,"0",$BC
          .WORD L605     ; link to 0=
          .WORD *+4
ZLESS     .WORD *+2
          ASL 1,X
          TYA
          ROL A
          STY 1,X
          STA 0,X
          JMP NEXT
;
;                                       +
;                                       SCREEN 29 LINE 1
;
L632      .BYTE $81,$AB
          .WORD L619     ; link to V-ADJ
          .WORD *+4
PLUS      .WORD *+2
          CLC
          LDA 0,X
          ADC 2,X
          STA 2,X
          LDA 1,X
          ADC 3,X
          STA 3,X
          INX
          INX
          JMP NEXT
;
;                                       D+
;                                       SCREEN 29 LINE 4
;
L649      .BYTE $82,"D",$AB
          .WORD L632     ;    LINK TO +
          .WORD *+4
DPLUS     .WORD *+2
          CLC
          LDA 2,X
          ADC 6,X
          STA 6,X
          LDA 3,X
          ADC 7,X
          STA 7,X
          LDA 0,X
          ADC 4,X
          STA 4,X
          LDA 1,X
          ADC 5,X
          STA 5,X
          JMP POPTWO
;
;                                       MINUS
;                                       SCREEN 29 LINE 9
;
L670      .BYTE $85,"MINU",$D3
          .WORD L649     ; link to D+
          .WORD *+4
MINUS     .WORD *+2
          SEC
          TYA
          SBC 0,X
          STA 0,X
          TYA
          SBC 1,X
          STA 1,X
          JMP NEXT
;
;                                       DMINUS
;                                       SCREEN 29 LINE 12
;
L685      .BYTE $86,"DMINU",$D3
          .WORD L670     ; link to  MINUS
          .WORD *+4
DMINU     .WORD *+2
          SEC
          TYA
          SBC 2,X
          STA 2,X
          TYA
          SBC 3,X
          STA 3,X
          JMP MINUS+3
;
;                                       OVER
;                                       SCREEN 30 LINE 1
;
L700      .BYTE $84,"OVE",$D2
          .WORD L685     ; link to DMINUS
          .WORD *+4
OVER      .WORD *+2
          LDA 2,X
          PHA
          LDA 3,X
          JMP PUSH
;
;                                       DROP
;                                       SCREEN 30 LINE 4
;
L711      .BYTE $84,"DRO",$D0
          .WORD L700     ; link to OVER
          .WORD *+4
DROP      .WORD POP
;
;                                       SWAP
;                                       SCREEN 30 LINE 8
;
L718      .BYTE $84,"SWA",$D0
          .WORD L711     ; link to DROP
          .WORD *+4
SWAP      .WORD *+2
          LDA 2,X
          PHA
          LDA 0,X
          STA 2,X
          LDA 3,X
          LDY 1,X
          STY 3,X
          JMP PUT
;
;                                       DUP
;                                       SCREEN 30 LINE 21
;
L733      .BYTE $83,"DU",$D0
          .WORD L718     ; link to SWAP
          .WORD *+4
DUP       .WORD *+2
          LDA 0,X
          PHA
          LDA 1,X
          JMP PUSH
;
;                                       +!
;                                       SCREEN 31 LINE 2
;
L744      .BYTE $82,"+",$A1
          .WORD L733     ; link to DUP
          .WORD *+4
PSTOR     .WORD *+2
          CLC
          LDA (0,X)      ; fetch 16 bit value addressed by
          ADC 2,X        ; bottom of  stack, adding to
          STA (0,X)      ; second item on stack, and return
          INC 0,X        ; to memory
          BNE L754
          INC 1,X
L754      LDA (0,X)
          ADC 3,X
          STA (0,X)
          JMP POPTWO
;
;                                       TOGGLE
;                                       SCREEN 31 LINE 7
;
L762      .BYTE $81,"TOGGL",$C5
          .WORD L744     ; link to +!
          .WORD *+4
TOGGL     .WORD *+2
          LDA (2,X)      ; complement bits in memory address
          EOR 0,X        ; second on stack, by pattern on
          STA (2,X)      ; bottom of stack.
          JMP POPTWO
;
;                                       @
;                                       SCREEN 32 LINE 1
;
L773      .BYTE $81,$C0
          .WORD L762     ; link to TOGGLE
          .WORD *+4
AT        .WORD *+2
          LDA (0,X)
          PHA
          INC 0,X
          BNE L781
          INC 1,X
L781      LDA (0,X)
          JMP PUT
;
;                                       C@
;                                       SCREEN 32 LINE 5
;
L787      .BYTE $82,"C",$C0
          .WORD L773     ; link to @
          .WORD *+4
CAT       .WORD *+2
          LDA (0,X)      ; fetch byte addressed by bottom of
          STA 0,X        ; stack to stack, zeroing the high
          STY 1,X        ; byte
          JMP NEXT
;
;                                       !
;                                       SCREEN 32 LINE 8
;
L798      .BYTE $81,$A1
          .WORD L787     ; link to C@
          .WORD *+4
STORE     .WORD *+2
          LDA 2,X
          STA (0,X)      ; store second 16bit value on stack
          INC 0,X        ; to memory as addressed by bottom
          BNE L806       ; of stack.
          INC 1,X
L806      LDA 3,X
          STA (0,X)
          JMP POPTWO
;
;                                       C!
;                                       SCREEN 32 LINE 12
;
L813      .BYTE $82,"C",$A1
          .WORD L798     ; link to !
          .WORD *+4
CSTOR     .WORD *+2
          LDA 2,X
          STA (0,X)
          JMP POPTWO
;
;                                       :
;                                       SCREEN 33 LINE 2
;
L823      .BYTE $C1,$BA
          .WORD L813     ; link to C!
          .WORD *+4
COLON     .WORD DOCOL
          .WORD QEXEC
          .WORD SCSP
          .WORD CURR
          .WORD AT
          .WORD CON
          .WORD STORE
          .WORD CREAT
          .WORD RBRAC
          .WORD PSCOD
;
DOCOL     LDA IP+1
          PHA
          LDA IP
          PHA

          CLC
          LDA W
          ADC #2
          STA IP
          TYA
          ADC W+1
          STA IP+1
          JMP NEXT
;
;                                       ;
;                                       SCREEN 33 LINE 9
;
L853      .BYTE $C1,$BB
          .WORD L823     ; link to :
          .WORD *+4
          .WORD DOCOL
          .WORD QCSP
          .WORD COMP
          .WORD SEMIS
          .WORD SMUDG
          .WORD LBRAC
          .WORD SEMIS
;
;                                       CONSTANT
;                                       SCREEN 34 LINE 1
;
L867      .BYTE $88,"CONSTAN",$D4
          .WORD L853     ; link to ;
          .WORD *+4
CONST     .WORD DOCOL
          .WORD CREAT
          .WORD SMUDG
          .WORD COMMA
          .WORD PSCOD
;
DOCON     LDY #2
          LDA (W),Y
          PHA
          INY
          LDA (W),Y
          JMP PUSH
;
;                                       VARIABLE
;                                       SCREEN 34 LINE 5
;
L885      .BYTE $88,"VARIABL",$C5
          .WORD L867     ; link to CONSTANT
          .WORD *+4
VAR       .WORD DOCOL
          .WORD CONST
          .WORD PSCOD
;
DOVAR     CLC
          LDA W
          ADC #2
          PHA
          TYA
          ADC W+1
          JMP PUSH
;
;                                       USER
;                                       SCREEN 34 LINE 10
;
L902      .BYTE $84,"USE",$D2
          .WORD L885     ; link to VARIABLE
          .WORD *+4
USER      .WORD DOCOL
          .WORD CONST
          .WORD PSCOD
;
DOUSE     LDY #2
          CLC
          LDA (W),Y
          ADC UP
          PHA
          LDA #0
          ADC UP+1
          JMP PUSH
;
;                                       0
;                                       SCREEN 35 LINE 2
;
L920      .BYTE $81,$B0
          .WORD L902     ; link to USER
          .WORD *+4
ZERO      .WORD DOCON
          .WORD 0
;
;                                       1
;                                       SCREEN 35 LINE 2
;
L928      .BYTE $81,$B1
          .WORD L920     ; link to 0
          .WORD *+4
ONE       .WORD DOCON
          .WORD 1
;
;                                       2
;                                       SCREEN 35 LINE 3
;
L936      .BYTE $81,$B2
          .WORD L928     ; link to 1
          .WORD *+4
TWO       .WORD DOCON
          .WORD 2
;
;                                       3
;                                       SCREEN 35 LINE 3
;
L944      .BYTE $81,$B3
          .WORD L936     ; link to 2
          .WORD *+4
THREE     .WORD DOCON
          .WORD 3
;
;                                       BL
;                                       SCREEN 35 LINE 4
;
L952      .BYTE $82,"B",$CC
          .WORD L944     ; link to 3
          .WORD *+4
BL        .WORD DOCON
          .WORD $20
;
;                                       C/L
;                                       SCREEN 35 LINE 5
;                                       Characters per line
L960      .BYTE $83,"C/",$CC
          .WORD L952     ; link to BL
          .WORD *+4
CSLL      .WORD DOCON
          .WORD 64
;
;                                       FIRST
;                                       SCREEN 35 LINE 7
;
L968      .BYTE $85,"FIRS",$D4
          .WORD L960     ; link to C/L
          .WORD *+4
FIRST     .WORD DOCON
          .WORD DAREA    ; bottom of disk buffer area
;
;                                       LIMIT
;                                       SCREEN 35 LINE 8
;
L976      .BYTE $85,"LIMI",$D4
          .WORD L968     ; link to FIRST
          .WORD *+4
LIMIT     .WORD DOCON
          .WORD UAREA    ; buffers end at user area
;
;                                       B/BUF
;                                       SCREEN 35 LINE 9
;                                       Bytes per Buffer
;
L984      .BYTE $85,"B/BU",$C6
          .WORD L976     ; link to LIMIT
          .WORD *+4
BBUF      .WORD DOCON
          .WORD SSIZE    ; sector size
;
;                                       B/SCR
;                                       SCREEN 35 LINE 10
;                                       Blocks per screen
;
L992      .BYTE $85,"B/SC",$D2
          .WORD L984     ; link to B/BUF
          .WORD *+4
BSCR      .WORD DOCON
          .WORD 8        ; blocks to make one screen





;
;                                       +ORIGIN
;                                       SCREEN 35 LINE 12
;
L1000     .BYTE $87,"+ORIGI",$CE
          .WORD L992     ; link to B/SCR
          .WORD *+4
PORIG     .WORD DOCOL
          .WORD LIT,ORIG
          .WORD PLUS
          .WORD SEMIS
;
;                                       TIB
;                                       SCREEN 36 LINE 4
;
L1010     .BYTE $83,"TI",$C2
          .WORD L1000    ; link to +ORIGIN
          .WORD *+4
TIB       .WORD DOUSE
          .BYTE $A
;
;                                       WIDTH
;                                       SCREEN 36 LINE 5
;
L1018     .BYTE $85,"WIDT",$C8
          .WORD L1010    ; link to TIB
          .WORD *+4
WIDTH     .WORD DOUSE
          .BYTE $C
;
;                                       WARNING
;                                       SCREEN 36 LINE 6
;
L1026     .BYTE $87,"WARNIN",$C7
          .WORD L1018    ; link to WIDTH
          .WORD *+4
WARN      .WORD DOUSE
          .BYTE $E
;
;                                       FENCE
;                                       SCREEN 36 LINE 7
;
L1034     .BYTE $85,"FENC",$C5
          .WORD L1026    ; link to WARNING
          .WORD *+4
FENCE     .WORD DOUSE
          .BYTE $10
;
;
;                                       DP
;                                       SCREEN 36 LINE 8
;
L1042     .BYTE $82,"D",$D0
          .WORD L1034    ; link to FENCE
          .WORD *+4
DP        .WORD DOUSE
          .BYTE $12
;
;                                       VOC-LINK
;                                       SCREEN 36 LINE 9
;
L1050     .BYTE $88,"VOC-LIN",$CB
          .WORD L1042    ; link to DP
          .WORD *+4
VOCL      .WORD DOUSE
          .BYTE $14
;
;                                       BLK
;                                       SCREEN 36 LINE 10
;
L1058     .BYTE $83,"BL",$CB
          .WORD L1050    ; link to VOC-LINK
          .WORD *+4
BLK       .WORD DOUSE
          .BYTE $16
;
;                                       IN
;                                       SCREEN 36 LINE 11
;
L1066     .BYTE $82,"I",$CE
          .WORD L1058    ; link to BLK
          .WORD *+4
IN        .WORD DOUSE
          .BYTE $18
;
;                                       OUT
;                                       SCREEN 36 LINE 12
;
L1074     .BYTE $83,"OU",$D4
          .WORD L1066    ; link to IN
          .WORD *+4
OUT       .WORD DOUSE
          .BYTE $1A
;
;                                       SCR
;                                       SCREEN 36 LINE 13
;
L1082     .BYTE $83,"SC",$D2
          .WORD L1074    ; link to OUT
          .WORD *+4
SCR       .WORD DOUSE
          .BYTE $1C
;
;                                       OFFSET
;                                       SCREEN 37 LINE 1
;
L1090     .BYTE $86,"OFFSE",$D4
          .WORD L1082    ; link to SCR
          .WORD *+4
OFSET     .WORD DOUSE
          .BYTE $1E
;
;                                       CONTEXT
;                                       SCREEN 37 LINE 2
;
L1098     .BYTE $87,"CONTEX",$D4
          .WORD L1090    ; link to OFFSET
          .WORD *+4
CON       .WORD DOUSE
          .BYTE $20
;
;                                       CURRENT
;                                       SCREEN 37 LINE 3
;
L1106     .BYTE $87,"CURREN",$D4
          .WORD L1098    ; link to CONTEXT
          .WORD *+4
CURR      .WORD DOUSE
          .BYTE $22
;
;                                       STATE
;                                       SCREEN 37 LINE 4
;
L1114     .BYTE $85,"STAT",$C5
          .WORD L1106    ; link to CURRENT
          .WORD *+4
STATE     .WORD DOUSE
          .BYTE $24
;
;                                       BASE
;                                       SCREEN 37 LINE 5
;
L1122     .BYTE $84,"BAS",$C5
          .WORD L1114    ; link to STATE
          .WORD *+4
BASE      .WORD DOUSE
          .BYTE $26
;
;                                       DPL
;                                       SCREEN 37 LINE 6
;
L1130     .BYTE $83,"DP",$CC
          .WORD L1122    ; link to BASE
          .WORD *+4
DPL       .WORD DOUSE
          .BYTE $28
;
;                                       FLD
;                                       SCREEN 37 LINE 7
;
L1138     .BYTE $83,"FL",$C4
          .WORD L1130    ; link to DPL
          .WORD *+4
FLD       .WORD DOUSE
          .BYTE $2A
;
;
;
;                                       CSP
;                                       SCREEN 37 LINE 8
;
L1146     .BYTE $83,"CS",$D0
          .WORD L1138    ; link to FLD
          .WORD *+4
CSP       .WORD DOUSE
          .BYTE $2C
;
;                                       R#
;                                       SCREEN 37  LINE 9
;
L1154     .BYTE $82,"R",$A3
          .WORD L1146    ; link to CSP
          .WORD *+4
RNUM      .WORD DOUSE
          .BYTE $2E
;
;                                       HLD
;                                       SCREEN 37 LINE 10
;
L1162     .BYTE $83,"HL",$C4
          .WORD L1154    ; link to R#
          .WORD *+4
HLD       .WORD DOUSE
          .BYTE $30
;

;                                       DPm
;                                       
;
L1169     .BYTE $83,"DP",$ED
          .WORD L1162    ; link to HLD
          .WORD *+4
DPMax     .WORD DOUSE
          .BYTE $32

;                                       1+
;                                       SCREEN 38 LINE  1
;
L1170     .BYTE $82,"1",$AB
          .WORD L1169    ; link to DPMax
          .WORD *+4
ONEP      .WORD DOCOL
          .WORD ONE
          .WORD PLUS
          .WORD SEMIS
;
;                                       2+
;                                       SCREEN 38 LINE 2
;
L1180     .BYTE $82,"2",$AB
          .WORD L1170    ; link to 1+
          .WORD *+4
TWOP      .WORD DOCOL
          .WORD TWO
          .WORD PLUS
          .WORD SEMIS
;
;                                       HERE
;                                       SCREEN 38 LINE 3
;
L1190     .BYTE $84,"HER",$C5
          .WORD L1180    ; link to 2+
          .WORD *+4
HERE      .WORD DOCOL
          .WORD DP
          .WORD AT
          .WORD SEMIS
;
;                                       ALLOT
;                                       SCREEN 38 LINE 4
;
L1200     .BYTE $85,"ALLO",$D4
          .WORD L1190    ; link to HERE
          .WORD *+4
ALLOT     .WORD DOCOL
          .WORD DP
          .WORD PSTOR
          .WORD SEMIS
;
;                                       ,
;                                       SCREEN 38 LINE 5
;
L1210     .BYTE $81,$AC
          .WORD L1200    ; link to ALLOT
          .WORD *+4
COMMA     .WORD DOCOL
          .WORD HERE
          .WORD STORE
          .WORD TWO
          .WORD ALLOT
          .WORD SEMIS
;
;                                       C,
;                                       SCREEN 38 LINE 6
;
L1222     .BYTE $82,"C",$AC
          .WORD L1210    ; link to ,
          .WORD *+4
CCOMM     .WORD DOCOL
          .WORD HERE
          .WORD CSTOR
          .WORD ONE
          .WORD ALLOT
          .WORD SEMIS
;
;                                       -
;                                       SCREEN 38 LINE 7
;
L1234     .BYTE $81,$AD
          .WORD L1222    ; link to C,
          .WORD *+4
SUB       .WORD DOCOL
          .WORD MINUS
          .WORD PLUS
          .WORD SEMIS
;
;                                       =
;                                       SCREEN 38 LINE 8
;
L1244     .BYTE $81,$BD
          .WORD L1234    ; link to -
          .WORD *+4
EQUAL     .WORD DOCOL
          .WORD SUB
          .WORD ZEQU
          .WORD SEMIS
;
;                                       U<
;                                       Unsigned less than
;
L1246     .BYTE $82,"U",$BC
          .WORD L1244    ; link to =
          .WORD *+4
ULESS     .WORD DOCOL
          .WORD SUB      ; subtract two values
          .WORD ZLESS    ; test sign
          .WORD SEMIS
;
;                                       <
;                                       Altered from model
;                                       SCREEN 38 LINE 9
;
L1254     .BYTE $81,$BC
          .WORD L1246    ; link to U<
          .WORD *+4
LESS      .WORD *+2
          SEC
          LDA 2,X
          SBC 0,X        ; subtract
          LDA 3,X
          SBC 1,X
          STY 3,X        ; zero high byte
          BVC L1258
          EOR #$80       ; correct overflow
L1258     BPL L1260
          INY            ; invert boolean
L1260     STY 2,X        ; leave boolean
          JMP POP
;
;                                       >
;                                       SCREEN 38 LINE 10
L1264     .BYTE $81,$BE
          .WORD L1254    ; link to <
          .WORD *+4
GREAT     .WORD DOCOL
          .WORD SWAP
          .WORD LESS
          .WORD SEMIS
;
;                                       ROT
;                                       SCREEN 38 LINE 11
;
L1274     .BYTE $83,"RO",$D4
          .WORD L1264    ; link to >
          .WORD *+4
ROT       .WORD DOCOL
          .WORD TOR
          .WORD SWAP
          .WORD RFROM
          .WORD SWAP
          .WORD SEMIS
;
;                                       SPACE
;                                       SCREEN 38 LINE 12
;
L1286     .BYTE $85,"SPAC",$C5
          .WORD L1274    ; link to ROT
          .WORD *+4
SPACE     .WORD DOCOL
          .WORD BL
          .WORD EMIT
          .WORD SEMIS
;
;                                       -DUP
;                                       SCREEN 38 LINE 13
;
L1296     .BYTE $84,"-DU",$D0
          .WORD L1286    ; link to SPACE
          .WORD *+4
DDUP      .WORD DOCOL
          .WORD DUP
          .WORD ZBRAN
L1301     .WORD $4       ; L1303-L1301
          .WORD DUP
L1303     .WORD SEMIS
;
;                                       TRAVERSE
;                                       SCREEN 39 LINE 14
;
L1308     .BYTE $88,"TRAVERS",$C5
          .WORD L1296    ; link to -DUP
          .WORD *+4
TRAV      .WORD DOCOL
          .WORD SWAP
L1312     .WORD OVER
          .WORD PLUS
          .WORD CLIT
          .BYTE $7F
          .WORD OVER
          .WORD CAT
          .WORD LESS
          .WORD ZBRAN
L1320     .WORD $FFF1    ; L1312-L1320
          .WORD SWAP
          .WORD DROP
          .WORD SEMIS
;
;                                       LATEST
;                                       SCREEN 39 LINE 6
;
L1328     .BYTE $86,"LATES",$D4
          .WORD L1308    ; link to TRAVERSE
          .WORD *+4
LATES     .WORD DOCOL
          .WORD CURR
          .WORD AT
          .WORD AT
          .WORD SEMIS
;
;
;                                       LFA   ( pfaptr --- lfa)
;                                       SCREEN 39 LINE 11
;
L1339     .BYTE $83,"LF",$C1
          .WORD L1328    ; link to LATEST
          .WORD *+4      ; <---- pfaptr
LFA       .WORD DOCOL    ; <---- cfa
          .WORD CLIT     ; <---- pfa
          .BYTE 2        ; rsc sonst 4
          .WORD SUB
          .WORD SEMIS
;
;                                       CFA   ( pfaptr --- cfa)
;                                       SCREEN 39 LINE 12
;
L1350     .BYTE $83,"CF",$C1
          .WORD L1339    ; link to LFA
          .WORD *+4
CFA       .WORD DOCOL
          .WORD AT       ; rsc
          .WORD TWO
          .WORD SUB
          .WORD SEMIS
;
;                                       NFA   ( pfaptr --- nfa)        
;                                       SCREEN 39 LINE 13
;                                       
L1360     .BYTE $83,"NF",$C1
          .WORD L1350    ; link to CFA
          .WORD *+4
NFA       .WORD DOCOL
          .WORD CLIT
          .BYTE $3       ; rsc  sonst 5
          .WORD SUB
          .WORD LIT,$FFFF
          .WORD TRAV
          .WORD SEMIS
;
;                                       PFAPTR ( nfa --- pfaptr)
;                                       SCREEN 39 LINE 14
;
L1373     .BYTE $83,"PF",$C1
          .WORD L1360    ; link to NFA
          .WORD *+4
PFAPTR    .WORD DOCOL
          .WORD ONE
          .WORD TRAV
          .WORD CLIT
          .BYTE 3        ; rsc  sonst 5
          .WORD PLUS
          .WORD SEMIS
;
;                                       !CSP
;                                       SCREEN 40 LINE 1
;
L1386     .BYTE $84,"!CS",$D0
          .WORD L1373    ; link to PFAPTR
          .WORD *+4
SCSP      .WORD DOCOL
          .WORD SPAT
          .WORD CSP
          .WORD STORE
          .WORD SEMIS
;
;                                       ?ERROR
;                                       SCREEN 40 LINE 3
;
L1397     .BYTE $86,"?ERRO",$D2
          .WORD L1386    ; link to !CSP
          .WORD *+4
QERR      .WORD DOCOL
          .WORD SWAP
          .WORD ZBRAN
L1402     .WORD 8        ; L1406-L1402
          .WORD ERROR
          .WORD BRAN
L1405     .WORD 4        ; L1407-L1405
L1406     .WORD DROP
L1407     .WORD SEMIS
;
;                                       ?COMP
;                                       SCREEN 40 LINE 6
;
L1412     .BYTE $85,"?COM",$D0
          .WORD L1397    ; link to ?ERROR
          .WORD *+4
QCOMP     .WORD DOCOL
          .WORD STATE
          .WORD AT
          .WORD ZEQU
          .WORD CLIT
          .BYTE $11
          .WORD QERR
          .WORD SEMIS
;
;                                       ?EXEC
;                                       SCREEN 40 LINE 8
;
L1426     .BYTE $85,"?EXE",$C3
          .WORD L1412    ; link to ?COMP
          .WORD *+4
QEXEC     .WORD DOCOL
          .WORD STATE
          .WORD AT
          .WORD CLIT
          .BYTE $12
          .WORD QERR
          .WORD SEMIS
;
;                                       ?PAIRS
;                                       SCREEN 40 LINE 10
;
L1439     .BYTE $86,"?PAIR",$D3
          .WORD L1426    ; link to ?EXEC
          .WORD *+4
QPAIR     .WORD DOCOL
          .WORD SUB
          .WORD CLIT
          .BYTE $13
          .WORD QERR
          .WORD SEMIS
;
;                                       ?CSP
;                                       SCREEN 40 LINE 12
;
L1451     .BYTE $84,"?CS",$D0
          .WORD L1439    ; link to ?PAIRS
          .WORD *+4
QCSP      .WORD DOCOL
          .WORD SPAT
          .WORD CSP
          .WORD AT
          .WORD SUB
          .WORD CLIT
          .BYTE $14
          .WORD QERR
          .WORD SEMIS
;
;                                       ?LOADING
;                                       SCREEN 40 LINE 14
;
L1466     .BYTE $88,"?LOADIN",$C7
          .WORD L1451    ; link to ?CSP
          .WORD *+4
QLOAD     .WORD DOCOL
          .WORD BLK
          .WORD AT
          .WORD ZEQU
          .WORD CLIT
          .BYTE $16
          .WORD QERR
          .WORD SEMIS
;
;                                       COMPILE
;                                       SCREEN 41 LINE 2
;
L1480     .BYTE $87,"COMPIL",$C5
          .WORD L1466    ; link to ?LOADING
          .WORD *+4
COMP      .WORD DOCOL
          .WORD QCOMP
          .WORD RFROM
          .WORD DUP
          .WORD TWOP
          .WORD TOR
          .WORD AT
          .WORD COMMA
          .WORD SEMIS
;
;                                       [
;                                       SCREEN 41 LINE 5
;
L1495     .BYTE $C1,$DB
          .WORD L1480    ; link to COMPILE
          .WORD *+4
LBRAC     .WORD DOCOL
          .WORD ZERO
          .WORD STATE
          .WORD STORE
          .WORD SEMIS
;
;                                       ]
;                                       SCREEN 41 LINE 7
;
L1507     .BYTE $81,$DD
          .WORD L1495    ; link to [
          .WORD *+4
RBRAC     .WORD DOCOL
          .WORD CLIT
          .BYTE $C0
          .WORD STATE
          .WORD STORE
          .WORD SEMIS
;
;                                       SMUDGE
;                                       SCREEN 41 LINE 9
;
L1519     .BYTE $86,"SMUDG",$C5
          .WORD L1507    ; link to ]
          .WORD *+4
SMUDG     .WORD DOCOL
          .WORD LATES
          .WORD CLIT
          .BYTE $20
          .WORD TOGGL
          .WORD SEMIS
;
;                                       HEX
;                                       SCREEN 41 LINE 11
;
L1531     .BYTE $83,"HE",$D8
          .WORD L1519    ; link to SMUDGE
          .WORD *+4
HEX       .WORD DOCOL
          .WORD CLIT
          .BYTE 16
          .WORD BASE
          .WORD STORE
          .WORD SEMIS
;
;                                       DECIMAL
;                                       SCREEN 41 LINE 13
;
L1543     .BYTE $87,"DECIMA",$CC
          .WORD L1531    ; link to HEX
          .WORD *+4
DECIM     .WORD DOCOL
          .WORD CLIT
          .BYTE 10
          .WORD BASE
          .WORD STORE
          .WORD SEMIS
;
;
;
;                                       (;CODE)
;                                       SCREEN 42 LINE 2
;
L1555     .BYTE $87,"(;CODE",$A9
          .WORD L1543    ; link to DECIMAL
          .WORD *+4
PSCOD     .WORD DOCOL
          .WORD RFROM
          .WORD LATES
          .WORD PFAPTR
          .WORD CFA
          .WORD STORE
          .WORD SEMIS
;
;                                       ;CODE
;                                       SCREEN 42 LINE 6
;
L1568     .BYTE $C5,";COD",$C5
          .WORD L1555    ; link to (;CODE)
          .WORD *+4
          .WORD DOCOL
          .WORD QCSP
          .WORD COMP
          .WORD PSCOD
          .WORD LBRAC
          .WORD SMUDG
          .WORD SEMIS
;
;                                       <BUILDS
;                                       SCREEN 43 LINE 2
;
L1582     .BYTE $87,"<BUILD",$D3
          .WORD L1568    ; link to ;CODE
          .WORD *+4
BUILD     .WORD DOCOL
          .WORD ZERO
          .WORD CONST
          .WORD SEMIS
;
;                                       DOES>
;                                       SCREEN 43 LINE 4
;
L1592     .BYTE $85,"DOES",$BE
          .WORD L1582    ; link to <BUILDS
          .WORD *+4
DOES      .WORD DOCOL
          .WORD RFROM
          .WORD LATES
          .WORD PFAPTR
          .WORD STORE
          .WORD PSCOD
;
DODOE     LDA IP+1
          PHA
          LDA IP
          PHA
          LDY #2
          LDA (W),Y
          STA IP
          INY
          LDA (W),Y
          STA IP+1
          CLC
          LDA W
          ADC #4
          PHA
          LDA W+1
          ADC #0
          JMP PUSH
;
;                                       COUNT
;                                       SCREEN 44 LINE 1
;
L1622     .BYTE $85,"COUN",$D4
          .WORD L1592    ; link to DOES>
          .WORD *+4
COUNT     .WORD DOCOL
          .WORD DUP
          .WORD ONEP
          .WORD SWAP
          .WORD CAT
          .WORD SEMIS
;
;                                       TYPE
;                                       SCREEN 44 LINE 2
;
L1634     .BYTE $84,"TYP",$C5
          .WORD L1622    ; link to COUNT
          .WORD *+4
TYPE      .WORD DOCOL
          .WORD DDUP
          .WORD ZBRAN
L1639     .WORD $18      ; L1651-L1639
          .WORD OVER
          .WORD PLUS
          .WORD SWAP
          .WORD PDO
L1644     .WORD I
          .WORD CAT
          .WORD EMIT
          .WORD PLOOP
L1648     .WORD $FFF8    ; L1644-L1648
          .WORD BRAN
L1650     .WORD $4       ; L1652-L1650
L1651     .WORD DROP
L1652     .WORD SEMIS
;
;                                       -TRAILING
;                                       SCREEN 44 LINE 5
;
L1657     .BYTE $89,"-TRAILIN",$C7
          .WORD L1634    ; link to TYPE
          .WORD *+4
DTRAI     .WORD DOCOL
          .WORD DUP
          .WORD ZERO
          .WORD PDO
L1663     .WORD OVER
          .WORD OVER
          .WORD PLUS
          .WORD ONE
          .WORD SUB
          .WORD CAT
          .WORD BL
          .WORD SUB
          .WORD ZBRAN
L1672     .WORD 8        ; L1676-L1672
          .WORD LEAVE
          .WORD BRAN
L1675     .WORD 6        ; L1678-L1675
L1676     .WORD ONE
          .WORD SUB
L1678     .WORD PLOOP
L1679     .WORD $FFE0    ; L1663-L1679
          .WORD SEMIS
;
;                                       (.")
;                                       SCREEN 44 LINE 8
L1685     .BYTE $84,"(.\"",$A9
          .WORD L1657    ; link to -TRAILING
          .WORD *+4
PDOTQ     .WORD DOCOL
          .WORD R
          .WORD COUNT
          .WORD DUP
          .WORD ONEP
          .WORD RFROM
          .WORD PLUS
          .WORD TOR
          .WORD TYPE
          .WORD SEMIS
;
;                                       ."
;                                       SCREEN 44 LINE12
;
L1701     .BYTE $C2,".",$A2
          .WORD L1685    ; link to PDOTQ
          .WORD *+4
          .WORD DOCOL
          .WORD CLIT
          .BYTE $22
          .WORD STATE
          .WORD AT
          .WORD ZBRAN
L1709     .WORD $14      ;L1719-L1709
          .WORD COMP
          .WORD PDOTQ
          .WORD WORD
          .WORD HERE
          .WORD CAT
          .WORD ONEP
          .WORD ALLOT
          .WORD BRAN
L1718     .WORD $A       ;L1723-L1718
L1719     .WORD WORD
          .WORD HERE
          .WORD COUNT
          .WORD TYPE
L1723     .WORD SEMIS
;
;                                       EXPECT
;                                       SCREEN 45 LINE 2
;
L1729     .BYTE $86,"EXPEC",$D4
          .WORD L1701    ; link to ."
          .WORD *+4
EXPEC     .WORD DOCOL
          .WORD OVER
          .WORD PLUS
          .WORD OVER
          .WORD PDO
L1736     .WORD KEY
          .WORD DUP
          .WORD CLIT
          .BYTE $E
          .WORD PORIG
          .WORD AT
          .WORD EQUAL
          .WORD ZBRAN
L1744     .WORD $1F       ; L1760-L1744
          .WORD DROP
          .WORD CLIT
          .BYTE 08
          .WORD OVER
          .WORD I
          .WORD EQUAL
          .WORD DUP
          .WORD RFROM
          .WORD TWO
          .WORD SUB
          .WORD PLUS
          .WORD TOR
          .WORD SUB
          .WORD BRAN
L1759     .WORD $27       ; L1779-L1759
L1760     .WORD DUP
          .WORD CLIT
          .BYTE $0D
          .WORD EQUAL
          .WORD ZBRAN
L1765     .WORD $0E       ; L1772-L1765
          .WORD LEAVE
          .WORD DROP
          .WORD BL
          .WORD ZERO
          .WORD BRAN
L1771     .WORD 04        ; L1773-L1771
L1772     .WORD DUP
L1773     .WORD I
          .WORD CSTOR
          .WORD ZERO
          .WORD I
          .WORD ONEP
          .WORD STORE
L1779     .WORD EMIT
          .WORD PLOOP
L1781     .WORD $FFA9
          .WORD DROP      ; L1736-L1781
          .WORD SEMIS
;
;                                       QUERY
;                                       SCREEN 45 LINE 9
;
L1788     .BYTE $85,"QUER",$D9
          .WORD L1729    ; link to EXPECT
          .WORD *+4
QUERY     .WORD DOCOL
          .WORD TIB
          .WORD AT
          .WORD CLIT
          .BYTE 80       ; 80 characters from terminal
          .WORD EXPEC
          .WORD ZERO
          .WORD IN
          .WORD STORE
          .WORD SEMIS
;
;                                       X
;                                       SCREEN 45 LINE 11
;                                       Actually Ascii Null
;
L1804     .BYTE $C1,$80
          .WORD L1788    ; link to QUERY
          .WORD *+4
          .WORD DOCOL
          .WORD BLK
          .WORD AT
          .WORD ZBRAN
L1810     .WORD $2A      ; L1830-l1810
          .WORD ONE
          .WORD BLK
          .WORD PSTOR
          .WORD ZERO
          .WORD IN
          .WORD STORE
          .WORD BLK
          .WORD AT
          .WORD ZERO,BSCR
          .WORD USLAS
          .WORD DROP     ; fixed from model
          .WORD ZEQU
          .WORD ZBRAN
L1824     .WORD 8        ; L1828-L1824
          .WORD QEXEC
          .WORD RFROM
          .WORD DROP
L1828     .WORD BRAN
L1829     .WORD 6        ; L1832-L1829
L1830     .WORD RFROM
          .WORD DROP
L1832     .WORD SEMIS
;
;                                       FILL
;                                       SCREEN 46 LINE 1
;
;
L1838     .BYTE $84,"FIL",$CC
          .WORD L1804    ; link to X
          .WORD *+4
FILL      .WORD DOCOL
          .WORD SWAP
          .WORD TOR
          .WORD OVER
          .WORD CSTOR
          .WORD DUP
          .WORD ONEP
          .WORD RFROM
          .WORD ONE
          .WORD SUB
          .WORD CMOVE
          .WORD SEMIS
;
;                                       ERASE
;                                       SCREEN 46 LINE 4
;
L1856     .BYTE $85,"ERAS",$C5
          .WORD L1838    ; link to FILL
          .WORD *+4
ERASE     .WORD DOCOL
          .WORD ZERO
          .WORD FILL
          .WORD SEMIS
;
;                                       BLANKS
;                                       SCREEN 46 LINE 7
;
L1866     .BYTE $86,"BLANK",$D3
          .WORD L1856    ; link to ERASE
          .WORD *+4
BLANK     .WORD DOCOL
          .WORD BL
          .WORD FILL
          .WORD SEMIS
;
;                                       HOLD
;                                       SCREEN 46 LINE 10
;
L1876     .BYTE $84,"HOL",$C4
          .WORD L1866    ; link to BLANKS
          .WORD *+4
HOLD      .WORD DOCOL
          .WORD LIT,$FFFF
          .WORD HLD
          .WORD PSTOR
          .WORD HLD
          .WORD AT
          .WORD CSTOR
          .WORD SEMIS
;
;                                       PAD
;                                       SCREEN 46 LINE 13
;
L1890     .BYTE $83,"PA",$C4
          .WORD L1876    ; link to HOLD
          .WORD *+4
PAD       .WORD DOCOL
          .WORD HERE
          .WORD CLIT
          .BYTE 68       ; PAD is 68 bytes above here.
          .WORD PLUS
          .WORD SEMIS
;
;                                       WORD
;                                       SCREEN 47 LINE 1
;
L1902     .BYTE $84,"WOR",$C4
          .WORD L1890    ; link to PAD
          .WORD *+4
WORD      .WORD DOCOL
          .WORD BLK
          .WORD AT
          .WORD ZBRAN
L1908     .WORD $C       ; L1914-L1908
          .WORD BLK
          .WORD AT
          .WORD BLOCK
          .WORD BRAN
L1913     .WORD $6       ; L1916-L1913
L1914     .WORD TIB
          .WORD AT
L1916     .WORD IN
          .WORD AT
          .WORD PLUS
          .WORD SWAP
          .WORD ENCL
          .WORD HERE
          .WORD CLIT
          .BYTE $22
          .WORD BLANK
          .WORD IN
          .WORD PSTOR
          .WORD OVER
          .WORD SUB
          .WORD TOR
          .WORD R
          .WORD HERE
          .WORD CSTOR
          .WORD PLUS
          .WORD HERE
          .WORD ONEP
          .WORD RFROM
          .WORD CMOVE
          .WORD SEMIS
;
;                                       UPPER
;                                       SCREEN 47 LINE 12
;
L1943     .BYTE $85,"UPPE",$D2
          .WORD L1902    ; link to WORD
          .WORD *+4
UPPER     .WORD DOCOL
          .WORD OVER     ; This routine converts text to U case
          .WORD PLUS     ; It allows interpretation from a term.
          .WORD SWAP     ; without a shift-lock.
          .WORD PDO
L1950     .WORD I
          .WORD CAT
          .WORD CLIT
          .BYTE $5F
          .WORD GREAT
          .WORD ZBRAN
L1956     .WORD 09       ; L1961-L1956
          .WORD I
          .WORD CLIT
          .BYTE $20
          .WORD TOGGL
L1961     .WORD PLOOP
L1962     .WORD $FFEA    ; L1950-L1962
          .WORD SEMIS
;
;                                       (NUMBER)
;                                       SCREEN 48 LINE 1
;
L1968     .BYTE $88,"(NUMBER",$A9
          .WORD L1943    ; link to UPPER
          .WORD *+4
PNUMB     .WORD DOCOL
L1971     .WORD ONEP
          .WORD DUP
          .WORD TOR
          .WORD CAT
          .WORD BASE
          .WORD AT
          .WORD DIGIT
          .WORD ZBRAN
L1979     .WORD $2C      ; L2001-L1979
          .WORD SWAP
          .WORD BASE
          .WORD AT
          .WORD USTAR
          .WORD DROP
          .WORD ROT
          .WORD BASE
          .WORD AT
          .WORD USTAR
          .WORD DPLUS
          .WORD DPL
          .WORD AT
          .WORD ONEP
          .WORD ZBRAN
L1994     .WORD 8        ; L1998-L1994
          .WORD ONE
          .WORD DPL
          .WORD PSTOR
L1998     .WORD RFROM
          .WORD BRAN
L2000     .WORD $FFC6    ; L1971-L2000
L2001     .WORD RFROM
          .WORD SEMIS
;
;                                       NUMBER
;                                       SCREEN 48 LINE 6
;
L2007     .BYTE $86,"NUMBE",$D2
          .WORD L1968    ; link to (NUMBER)
          .WORD *+4
NUMBER    .WORD DOCOL
          .WORD ZERO
          .WORD ZERO
          .WORD ROT
          .WORD DUP
          .WORD ONEP
          .WORD CAT
          .WORD CLIT
          .BYTE $2D
          .WORD EQUAL
          .WORD DUP
          .WORD TOR
          .WORD PLUS
          .WORD LIT,$FFFF
L2023     .WORD DPL
          .WORD STORE
          .WORD PNUMB
          .WORD DUP
          .WORD CAT
          .WORD BL
          .WORD SUB
          .WORD ZBRAN
L2031     .WORD $15      ; L2042-L2031
          .WORD DUP
          .WORD CAT
          .WORD CLIT
          .BYTE $2E
          .WORD SUB
          .WORD ZERO
          .WORD QERR
          .WORD ZERO
          .WORD BRAN
L2041     .WORD $FFDD    ; L2023-L2041
L2042     .WORD DROP
          .WORD RFROM
          .WORD ZBRAN
L2045     .WORD 4        ; L2047-L2045
          .WORD DMINU
L2047     .WORD SEMIS
;
;                                       -FIND
;                                       SCREEN 48 LINE 12
;
L2052     .BYTE $85,"-FIN",$C4
          .WORD L2007    ; link to NUMBER
          .WORD *+4
DFIND     .WORD DOCOL
          .WORD BL
          .WORD WORD
          .WORD HERE     ; )
          .WORD COUNT    ; |- Optional allowing free use of low
          .WORD UPPER    ; )  case from terminal
          .WORD HERE
          .WORD CON
          .WORD AT
          .WORD AT
          .WORD PFIND
          .WORD DUP
          .WORD ZEQU
          .WORD ZBRAN
L2068     .WORD $A       ; L2073-L2068
          .WORD DROP
          .WORD HERE
          .WORD LATES
          .WORD PFIND
L2073     .WORD SEMIS
;
;                                       (ABORT)
;                                       SCREEN 49 LINE 2
;
L2078     .BYTE $87,"(ABORT",$A9
          .WORD L2052    ; link to -FIND
          .WORD *+4
PABOR     .WORD DOCOL
          .WORD ABORT
          .WORD SEMIS
;
;                                       ERROR
;                                       SCREEN 49 LINE 4
;
L2087     .BYTE $85,"ERRO",$D2
          .WORD L2078    ; link to (ABORT)
          .WORD *+4
ERROR     .WORD DOCOL
          .WORD WARN
          .WORD AT
          .WORD ZLESS
          .WORD ZBRAN
L2094     .WORD $4       ; L2096-L2094
          .WORD PABOR
L2096     .WORD HERE
          .WORD COUNT
          .WORD TYPE
          .WORD PDOTQ
          .BYTE 4,"  ? "
          .WORD MESS
          .WORD SPSTO
          .WORD DROP,DROP; make room for 2 error values
          .WORD IN
          .WORD AT
          .WORD BLK
          .WORD AT
          .WORD QUIT
          .WORD SEMIS
;
;                                       ID.
;                                       SCREEN 49 LINE 9
;
L2113     .BYTE $83,"ID",$AE
          .WORD L2087    ; link to ERROR
          .WORD *+4
IDDOT     .WORD DOCOL
          .WORD PAD
          .WORD CLIT
          .BYTE $20
          .WORD CLIT
          .BYTE $5F
          .WORD FILL
          .WORD DUP
          .WORD PFAPTR
          .WORD LFA
          .WORD OVER
          .WORD SUB
          .WORD PAD
          .WORD SWAP
          .WORD CMOVE
          .WORD PAD
          .WORD COUNT
          .WORD CLIT
          .BYTE $1F
          .WORD ANDD
;          .WORD OVER    ; akr
;          .WORD OVER    ; akr
;          .WORD DUP     ; akr
;          .WORD CAT     ; akr
;          .WORD CLIT    ; akr
;          .BYTE $7F     ; akr
;          .WORD SWAP    ; akr
;          .WORD CSTOR   ; akr
          .WORD TYPE
          .WORD SPACE
          .WORD SEMIS
;
;                                       CREATE
;                                       SCREEN 50 LINE 2
;
L2142     .BYTE $86,"CREAT",$C5
          .WORD L2113    ; link to ID
          .WORD *+4
CREAT     .WORD DOCOL
          .WORD DPMax    ; AUKr
          .WORD AT       ; AUKr
;          .WORD TIB      ;)
          .WORD HERE     ;|
          .WORD CLIT     ;|  6502 only, assures
          .BYTE $A0      ;|  room exists in dict.
          .WORD PLUS     ;|
          .WORD ULESS    ;|
          .WORD TWO      ;|
          .WORD QERR     ;)
          .WORD DFIND
          .WORD ZBRAN
L2155     .WORD $0F
          .WORD DROP
          .WORD NFA
          .WORD IDDOT
          .WORD CLIT
          .BYTE 4
          .WORD MESS
          .WORD SPACE
L2163     .WORD HERE
          .WORD DUP
          .WORD CAT
          .WORD WIDTH
          .WORD AT
          .WORD MIN
          .WORD ONEP
          .WORD ALLOT
          .WORD DP       ;)
          .WORD CAT      ;| 6502 only. The code field
          .WORD CLIT     ;| must not straddle page
          .BYTE $FD      ;| boundaries
          .WORD EQUAL    ;|
          .WORD ALLOT    ;)
          .WORD DUP
          .WORD CLIT
          .BYTE $A0
          .WORD TOGGL
          .WORD HERE
          .WORD ONE
          .WORD SUB
          .WORD CLIT
          .BYTE $80
          .WORD TOGGL
          .WORD LATES
          .WORD COMMA    ; lfa
          .WORD CURR
          .WORD AT
          .WORD STORE
          .WORD HERE
          .WORD TWOP
          .WORD DUP      ; rsc
          .WORD TWOP     ; rsc
          .WORD COMMA    ; rsc pfaptr
          .WORD COMMA    ; cfa
          .WORD SEMIS
;
;                                       [COMPILE]
;                                       SCREEN 51 LINE 2
;
L2200     .BYTE $C9,"[COMPILE",$DD
          .WORD L2142    ; link to CREATE
          .WORD *+4
          .WORD DOCOL
          .WORD DFIND
          .WORD ZEQU
          .WORD ZERO
          .WORD QERR
          .WORD DROP
          .WORD CFA
          .WORD COMMA
          .WORD SEMIS
;
;                                       LITERAL
;                                       SCREEN 51 LINE 2
;
L2216     .BYTE $C7,"LITERA",$CC
          .WORD L2200    ; link to [COMPILE]
          .WORD *+4
LITER     .WORD DOCOL
          .WORD STATE
          .WORD AT
          .WORD ZBRAN
L2222     .WORD 8        ; L2226-L2222
          .WORD COMP
          .WORD LIT
          .WORD COMMA
L2226     .WORD SEMIS
;
;                                       DLITERAL
;                                       SCREEN 51 LINE 8
;
L2232     .BYTE $C8,"DLITERA",$CC
          .WORD L2216    ; link to LITERAL
          .WORD *+4
DLIT      .WORD DOCOL
          .WORD STATE
          .WORD AT
          .WORD ZBRAN
L2238     .WORD 8        ; L2242-L2238
          .WORD SWAP
          .WORD LITER
          .WORD LITER
L2242     .WORD SEMIS
;
;                                       ?STACK
;                                       SCREEN 51 LINE 13
;
L2248     .BYTE $86,"?STAC",$CB
          .WORD L2232    ; link to DLITERAL
          .WORD *+4
QSTAC     .WORD DOCOL
          .WORD CLIT
          .BYTE TOS
          .WORD SPAT
          .WORD ULESS
          .WORD ONE
          .WORD QERR
          .WORD SPAT
          .WORD CLIT
          .BYTE BOS
          .WORD ULESS
          .WORD CLIT
          .BYTE 7
          .WORD QERR
          .WORD SEMIS
;
;                                       INTERPRET
;                                       SCREEN 52 LINE 2
;
L2269     .BYTE $89,"INTERPRE",$D4
          .WORD L2248    ; link to ?STACK
          .WORD *+4
INTER     .WORD DOCOL
L2272     .WORD DFIND
          .WORD ZBRAN
L2274     .WORD $1E      ; L2289-L2274
          .WORD STATE
          .WORD AT
          .WORD LESS
          .WORD ZBRAN
L2279     .WORD $A       ; L2284-L2279
          .WORD CFA
          .WORD COMMA
          .WORD BRAN
L2283     .WORD $6       ; L2286-L2283
L2284     .WORD CFA
          .WORD EXEC
L2286     .WORD QSTAC
          .WORD BRAN
L2288     .WORD $1C      ; L2302-L2288
L2289     .WORD HERE
          .WORD NUMBER
          .WORD DPL
          .WORD AT
          .WORD ONEP
          .WORD ZBRAN
L2295     .WORD 8        ; L2299-L2295
          .WORD DLIT
          .WORD BRAN
L2298     .WORD $6       ; L2301-L2298
L2299     .WORD DROP
          .WORD LITER
L2301     .WORD QSTAC
L2302     .WORD BRAN
L2303     .WORD $FFC2    ; L2272-L2303
;
;                                       IMMEDIATE
;                                       SCREEN 53 LINE 1
;
L2309     .BYTE $89,"IMMEDIAT",$C5
          .WORD L2269;   ; link to INTERPRET
          .WORD *+4
          .WORD DOCOL
          .WORD LATES
          .WORD CLIT
          .BYTE $40
          .WORD TOGGL
          .WORD SEMIS
;
;                                       VOCABULARY
;                                       SCREEN 53 LINE 4
;
L2321     .BYTE $8A,"VOCABULAR",$D9
          .WORD L2309    ; link to IMMEDIATE
          .WORD *+4
          .WORD DOCOL
          .WORD BUILD
          .WORD LIT,$A081
          .WORD COMMA
          .WORD CURR
          .WORD AT
          .WORD CFA
          .WORD COMMA
          .WORD HERE
          .WORD VOCL
          .WORD AT
          .WORD COMMA
          .WORD VOCL
          .WORD STORE
          .WORD DOES
DOVOC     .WORD TWOP
          .WORD CON
          .WORD STORE
          .WORD SEMIS
;
;                                       FORTH
;                                       SCREEN 53 LINE 9
;
;L2346     .BYTE $C5,"FORT",$C8
;          .WORD L2321    ; link to VOCABULARY
;          .WORD *+4
;FORTH     .WORD DODOE
;          .WORD DOVOC
;          .WORD $A081
;XFOR      .WORD NTOP     ; points to top name in FORTH
;VL0       .WORD 0        ; last vocab link ends at zero
;
;                                       DEFINITIONS
;                                       SCREEN 53 LINE 11
;
;
L2357     .BYTE $8B,"DEFINITION",$D3
          .WORD L2321    ; link to VOCABULARY   ; .WORD L2346    ; link to FORTH
          .WORD *+4
DEFIN     .WORD DOCOL
          .WORD CON
          .WORD AT
          .WORD CURR
          .WORD STORE
          .WORD SEMIS
;
;                                       (
;                                       SCREEN 53 LINE 14
;
L2369     .BYTE $C1,$A8
          .WORD L2357    ; link to DEFINITIONS
          .WORD *+4
          .WORD DOCOL
          .WORD CLIT
          .BYTE $29
          .WORD WORD
          .WORD SEMIS
;
;                                       QUIT
;                                       SCREEN 54 LINE 2
;
L2381     .BYTE $84,"QUI",$D4
          .WORD L2369    ; link to (
          .WORD *+4
QUIT      .WORD DOCOL
          .WORD ZERO
          .WORD BLK
          .WORD STORE
          .WORD LBRAC
L2388     .WORD RPSTO
          .WORD CR
          .WORD QUERY
          .WORD INTER
          .WORD STATE
          .WORD AT
          .WORD ZEQU
          .WORD ZBRAN
L2396     .WORD 7        ; L2399-L2396
          .WORD PDOTQ
          .BYTE 2,"OK"
L2399     .WORD BRAN
L2400     .WORD $FFE7    ; L2388-L2400
          .WORD SEMIS
;
;                                       ABORT
;                                       SCREEN 54 LINE 7
;
L2406     .BYTE $85,"ABOR",$D4
          .WORD L2381    ; link to QUIT
          .WORD *+4
ABORT     .WORD DOCOL
          .WORD SPSTO
          .WORD DECIM
          .WORD DR0
          .WORD CR
          .WORD PDOTQ
          .BYTE 14,"rsc3800forth00"
          .WORD FORTH-INITV+INITDP
          .WORD DEFIN
          .WORD QUIT
;
;                                       COLD
;                                       SCREEN 55 LINE 1
;
L2423     .BYTE $84,"COL",$C4
          .WORD L2406    ; link to ABORT
          .WORD *+4
COLD      .WORD *+2
          LDX #$BF
          TXS
          CLT
          CLD
          LDA #%00000110 ; stackpage1 microprocessormode 
          STA CPUM
          LDA #51        ; 2400bd   103=1200bd
          STA BRG
          LDA #%10110001 ; SIOen ASYNC RXEN TXEN 0 SRDY syncclk clk/4 
          STA SIOCON
          LDA #%00000000 ; CMOS 1stop nP 8b
          STA UARTCON
          LDA #%00000000 ; p40
          STA P4
          LDA #%00000001 ; P40=Output
          STA P4D
          LDA ORIG+$0C   ; from cold start area
          STA FORTH-INITV+INITDP+6
          LDA ORIG+$0D
          STA FORTH-INITV+INITDP+7
          LDY #INITVEND-INITV  ; FORTH UND TASK INS RAM
L2324     LDA INITV,Y
          STA INITDP,Y
          DEY
          BPL L2324    
          LDY #$15
          BNE L2433
WARM      LDY #$0F
L2433     LDA ORIG+$10
          STA UP
          LDA ORIG+$11
          STA UP+1
L2437     LDA ORIG+$0C,Y
          STA (UP),Y
          DEY
          BPL  L2437
          LDA #((ABORT+2) / $100)    ; actually #>(ABORT+2)
          STA IP+1
          LDA #((ABORT+2) & $FF)
          STA IP
          CLD
          CLT
          LDA #$6C
          STA W-1
          JMP RPSTO+2    ; And off we go !
;
;                                       S->D
;                                       SCREEN 56 LINE 1
;
L2453     .BYTE $84,"S->",$C4
          .WORD L2423    ; link to COLD
          .WORD *+4
STOD      .WORD DOCOL
          .WORD DUP
          .WORD ZLESS
          .WORD MINUS
          .WORD SEMIS
;
;                                       +-
;                                       SCREEN 56 LINE 4
;
L2464     .BYTE $82,"+",$AD
          .WORD L2453    ; link to S->D
          .WORD *+4
PM        .WORD DOCOL
          .WORD ZLESS
          .WORD ZBRAN
L2469     .WORD 4
          .WORD MINUS
L2471     .WORD SEMIS
;
;                                       D+-
;                                       SCREEN 56 LINE 6
;
L2476     .BYTE $83,"D+",$AD
          .WORD L2464    ; link to +-
          .WORD *+4
DPM       .WORD DOCOL
          .WORD ZLESS
          .WORD ZBRAN
L2481     .WORD 4        ; L2483-L2481
          .WORD DMINU
L2483     .WORD SEMIS
;
;                                       ABS
;                                       SCREEN 56 LINE 9
;
L2488     .BYTE $83,"AB",$D3
          .WORD L2476    ; link to D+-
          .WORD *+4
ABS       .WORD DOCOL
          .WORD DUP
          .WORD PM
          .WORD SEMIS
;
;                                       DABS
;                                       SCREEN 56 LINE 10
;
L2498     .BYTE $84,"DAB",$D3
          .WORD L2488    ; link to ABS
          .WORD *+4
DABS      .WORD DOCOL
          .WORD DUP
          .WORD DPM
          .WORD SEMIS
;
;                                       MIN
;                                       SCREEN 56 LINE 12
;
L2508     .BYTE $83,"MI",$CE
          .WORD L2498    ; link to DABS
          .WORD *+4
MIN       .WORD DOCOL
          .WORD OVER
          .WORD OVER
          .WORD GREAT
          .WORD ZBRAN
L2515     .WORD 4        ; L2517-L2515
          .WORD SWAP
L2517     .WORD DROP
          .WORD SEMIS
;
;                                       MAX
;                                       SCREEN 56 LINE 14
;
L2523     .BYTE $83,"MA",$D8
          .WORD L2508     ; link to MIN
          .WORD *+4
MAX       .WORD DOCOL
          .WORD OVER
          .WORD OVER
          .WORD LESS
          .WORD ZBRAN
L2530     .WORD 4        ; L2532-L2530
          .WORD SWAP
L2532     .WORD DROP
          .WORD SEMIS
;
;                                       M*
;                                       SCREEN 57 LINE 1
;
L2538     .BYTE $82,"M",$AA
          .WORD L2523    ; link to MAX
          .WORD *+4
MSTAR     .WORD DOCOL
          .WORD OVER
          .WORD OVER
          .WORD XOR
          .WORD TOR
          .WORD ABS
          .WORD SWAP
          .WORD ABS
          .WORD USTAR
          .WORD RFROM
          .WORD DPM
          .WORD SEMIS
;
;                                       M/
;                                       SCREEN 57 LINE 3
;
L2556     .BYTE $82,"M",$AF
          .WORD L2538    ; link to M*
          .WORD *+4
MSLAS     .WORD DOCOL
          .WORD OVER
          .WORD TOR
          .WORD TOR
          .WORD DABS
          .WORD R
          .WORD ABS
          .WORD USLAS
          .WORD RFROM
          .WORD R
          .WORD XOR
          .WORD PM
          .WORD SWAP
          .WORD RFROM
          .WORD PM
          .WORD SWAP
          .WORD SEMIS
;
;                                       *
;                                       SCREEN 57 LINE 7
;
L2579     .BYTE $81,$AA
          .WORD L2556    ; link to M/
          .WORD *+4
STAR      .WORD DOCOL
          .WORD USTAR
          .WORD DROP
          .WORD SEMIS
;
;                                       /MOD
;                                       SCREEN 57 LINE 8
;
L2589     .BYTE $84,"/MO",$C4
          .WORD L2579    ; link to *
          .WORD *+4
SLMOD     .WORD DOCOL
          .WORD TOR
          .WORD STOD
          .WORD RFROM
          .WORD MSLAS
          .WORD SEMIS
;
;                                       /
;                                       SCREEN 57 LINE 9
;
L2601     .BYTE $81,$AF
          .WORD L2589    ; link to /MOD
          .WORD *+4
SLASH     .WORD DOCOL
          .WORD SLMOD
          .WORD SWAP
          .WORD DROP
          .WORD SEMIS
;
;                                       MOD
;                                       SCREEN 57 LINE 10
;
L2612     .BYTE $83,"MO",$C4
          .WORD L2601    ; link to /
          .WORD *+4
MOD       .WORD DOCOL
          .WORD SLMOD
          .WORD DROP
          .WORD SEMIS
;
;                                       */MOD
;                                       SCREEN 57 LINE 11
;
L2622     .BYTE $85,"*/MO",$C4
          .WORD L2612    ; link to MOD
          .WORD *+4
SSMOD     .WORD DOCOL
          .WORD TOR
          .WORD MSTAR
          .WORD RFROM
          .WORD MSLAS
          .WORD SEMIS
;
;                                       */
;                                       SCREEN 57 LINE 13
;
L2634     .BYTE $82,"*",$AF
          .WORD L2622    ; link to */MOD
          .WORD *+4
SSLAS     .WORD DOCOL
          .WORD SSMOD
          .WORD SWAP
          .WORD DROP
          .WORD SEMIS
;
;                                       M/MOD
;                                       SCREEN 57 LINE 14
;
L2645     .BYTE $85,"M/MO",$C4
          .WORD L2634    ; link to */
          .WORD *+4
MSMOD     .WORD DOCOL
          .WORD TOR
          .WORD ZERO
          .WORD R
          .WORD USLAS
          .WORD RFROM
          .WORD SWAP
          .WORD TOR
          .WORD USLAS
          .WORD RFROM
          .WORD SEMIS
;
;                                       USE
;                                       SCREEN 58 LINE 1
;
L2662     .BYTE $83,"US",$C5
          .WORD L2645    ; link to M/MOD
          .WORD *+4
USE       .WORD DOVAR
          .WORD DAREA
;
;                                       PREV
;                                       SCREEN 58 LINE 2
;
L2670     .BYTE $84,"PRE",$D6
          .WORD L2662    ; link to USE
          .WORD *+4
PREV      .WORD DOVAR
          .WORD DAREA
;
;                                       +BUF
;                                       SCREEN 58 LINE 4
;
;
L2678     .BYTE $84,"+BU",$C6
          .WORD L2670    ; link to PREV
          .WORD *+4
PBUF      .WORD DOCOL
          .WORD LIT
          .WORD SSIZE+4  ; hold block #, one sector two num
          .WORD PLUS
          .WORD DUP
          .WORD LIMIT
          .WORD EQUAL
          .WORD ZBRAN
L2688     .WORD 6        ; L2691-L2688
          .WORD DROP
          .WORD FIRST
L2691     .WORD DUP
          .WORD PREV
          .WORD AT
          .WORD SUB
          .WORD SEMIS
;
;                                       UPDATE
;                                       SCREEN 58 LINE 8
;
L2700     .BYTE $86,"UPDAT",$C5
          .WORD L2678    ; link to +BUF
          .WORD *+4
UPDAT     .WORD DOCOL
          .WORD PREV
          .WORD AT
          .WORD AT
          .WORD LIT,$8000
          .WORD OR
          .WORD PREV
          .WORD AT
          .WORD STORE
          .WORD SEMIS
;
;                                       FLUSH
;
L2705     .BYTE $85,"FLUS",$C8
          .WORD L2700    ; link to UPDATE
          .WORD *+4
          .WORD DOCOL
          .WORD LIMIT,FIRST,SUB
          .WORD BBUF,CLIT
          .BYTE 4
          .WORD PLUS,SLASH,ONEP
          .WORD ZERO,PDO
L2835     .WORD LIT,$7FFF,BUFFR
          .WORD DROP,PLOOP
L2839     .WORD $FFF6    ; L2835-L2839
          .WORD SEMIS
;
;                                       EMPTY-BUFFERS
;                                       SCREEN 58 LINE 11
;
L2716     .BYTE $8D,"EMPTY-BUFFER",$D3
          .WORD L2705    ; link to FLUSH
          .WORD *+4
          .WORD DOCOL
          .WORD FIRST
          .WORD LIMIT
          .WORD OVER
          .WORD SUB
          .WORD ERASE
          .WORD SEMIS
;
;                                       DR0
;                                       SCREEN 58 LINE 14
;
L2729     .BYTE $83,"DR",$B0
          .WORD L2716    ; link to EMPTY-BUFFERS
          .WORD *+4
DR0       .WORD DOCOL
          .WORD ZERO
          .WORD OFSET
          .WORD STORE
          .WORD SEMIS
;
;                                       DR1
;                                       SCREEN 58 LINE 15
;
L2740     .BYTE $83,"DR",$B1
          .WORD L2729    ; link to DR0
          .WORD *+4
          .WORD DOCOL
          .WORD LIT,SECTR ; sectors per drive
          .WORD OFSET
          .WORD STORE
          .WORD SEMIS
;
;                                       BUFFER
;                                       SCREEN 59 LINE 1
;
L2751     .BYTE $86,"BUFFE",$D2
          .WORD L2740    ; link to DR1
          .WORD *+4
BUFFR     .WORD DOCOL
          .WORD USE
          .WORD AT
          .WORD DUP
          .WORD TOR
L2758     .WORD PBUF
          .WORD ZBRAN
L2760     .WORD $FFFC    ; L2758-L2760
          .WORD USE
          .WORD STORE
          .WORD R
          .WORD AT
          .WORD ZLESS
          .WORD ZBRAN
L2767     .WORD $14      ; L2776-L2767
          .WORD R
          .WORD TWOP
          .WORD R
          .WORD AT
          .WORD LIT,$7FFF
          .WORD ANDD
          .WORD ZERO
          .WORD RSLW
L2776     .WORD R
          .WORD STORE
          .WORD R
          .WORD PREV
          .WORD STORE
          .WORD RFROM
          .WORD TWOP
          .WORD SEMIS
;
;                                       BLOCK
;                                       SCREEN 60 LINE 1
;
L2788     .BYTE $85,"BLOC",$CB
          .WORD L2751    ; link to BUFFER
          .WORD *+4
BLOCK     .WORD DOCOL
          .WORD OFSET
          .WORD AT
          .WORD PLUS
          .WORD TOR
          .WORD PREV
          .WORD AT
          .WORD DUP
          .WORD AT
          .WORD R
          .WORD SUB
          .WORD DUP
          .WORD PLUS
          .WORD ZBRAN
L2804     .WORD $34      ; L2830-L2804
L2805     .WORD PBUF
          .WORD ZEQU
          .WORD ZBRAN
L2808     .WORD $14      ; L2818-L2808
          .WORD DROP
          .WORD R
          .WORD BUFFR
          .WORD DUP
          .WORD R
          .WORD ONE
          .WORD RSLW
          .WORD TWO
          .WORD SUB
L2818     .WORD DUP
          .WORD AT
          .WORD R
          .WORD SUB
          .WORD DUP
          .WORD PLUS
          .WORD ZEQU
          .WORD ZBRAN
L2826     .WORD $FFD6    ; L2805-L2826
          .WORD DUP
          .WORD PREV
          .WORD STORE
L2830     .WORD RFROM
          .WORD DROP
          .WORD TWOP
          .WORD SEMIS    ; end of BLOCK
;
;
;                                       (LINE)
;                                       SCREEN 61 LINE 2
;
L2838     .BYTE $86,"(LINE",$A9
          .WORD L2788    ; link to BLOCK
          .WORD *+4
PLINE     .WORD DOCOL
          .WORD TOR
          .WORD CSLL
          .WORD BBUF
          .WORD SSMOD
          .WORD RFROM
          .WORD BSCR
          .WORD STAR
          .WORD PLUS
          .WORD BLOCK
          .WORD PLUS
          .WORD CSLL
          .WORD SEMIS
;
;                                       .LINE
;                                       SCREEN 61 LINE 6
;
L2857     .BYTE $85,".LIN",$C5
          .WORD L2838    ; link to (LINE)
          .WORD *+4
DLINE     .WORD DOCOL
          .WORD PLINE
          .WORD DTRAI
          .WORD TYPE
          .WORD SEMIS
;
;                                       MESSAGE
;                                       SCREEN 61 LINE 9
;
L2868     .BYTE $87,"MESSAG",$C5
          .WORD L2857    ; link to .LINE
          .WORD *+4
MESS      .WORD DOCOL
          .WORD WARN
          .WORD AT
          .WORD ZBRAN
L2874     .WORD $1B      ; L2888-L2874
          .WORD DDUP
          .WORD ZBRAN
L2877     .WORD $11      ; L2886-L2877
          .WORD CLIT
          .BYTE 4
          .WORD OFSET
          .WORD AT
          .WORD BSCR
          .WORD SLASH
          .WORD SUB
          .WORD DLINE
L2886     .WORD BRAN
L2887     .WORD 13       ; L2891-L2887
L2888     .WORD PDOTQ
          .BYTE 6,"MSG # "
          .WORD DOT
L2891     .WORD SEMIS
;
;                                       LOAD
;                                       SCREEN 62 LINE 2
;
L2896     .BYTE $84,"LOA",$C4
          .WORD L2868    ; link to MESSAGE
          .WORD *+4
LOAD      .WORD DOCOL
          .WORD BLK
          .WORD AT
          .WORD TOR
          .WORD IN
          .WORD AT
          .WORD TOR
          .WORD ZERO
          .WORD IN
          .WORD STORE
          .WORD BSCR
          .WORD STAR
          .WORD BLK
          .WORD STORE
          .WORD INTER
          .WORD RFROM
          .WORD IN
          .WORD STORE
          .WORD RFROM
          .WORD BLK
          .WORD STORE
          .WORD SEMIS
;
;                                       -->
;                                       SCREEN 62 LINE 6
;
L2924     .BYTE $C3,"--",$BE
          .WORD L2896    ; link to LOAD
          .WORD *+4
          .WORD DOCOL
          .WORD QLOAD
          .WORD ZERO
          .WORD IN
          .WORD STORE
          .WORD BSCR
          .WORD BLK
          .WORD AT
          .WORD OVER
          .WORD MOD
          .WORD SUB
          .WORD BLK
          .WORD PSTOR
          .WORD SEMIS
;
;    XEMIT writes one ascii character to terminal
;
;
XEMIT     TYA
          SEC
          LDY #$1A
          ADC (UP),Y
          STA (UP),Y
          INY            ; bump user varaible OUT
          LDA #0
          ADC (UP),Y
          STA (UP),Y 
XEMIT0    LDA SIOSTS     ; warte bis buffer empty
          AND #$01          
          BEQ XEMIT0
          LDA 0,X        ; fetch character to output
          AND #$7F
          STA TBRB          
          JMP POP
;
;         XKEY reads one terminal keystroke to stack
;
;
XKEY      STX XSAVE
XKEY0     LDA SIOSTS     ; system depend port test
          AND #$02    
          BEQ XKEY0
          LDA TBRB
          LDX XSAVE      ; inputting a char to accumulator
          JMP PUSHOA
;
;         XQTER leaves a boolean representing terminal break
;
;
XQTER     LDA SIOSTS     ; system depend port test
          AND #$02    
          JMP PUSHOA
;
;         XCR displays a CR and LF to terminal
;
;
XCR       STX XSAVE
XCR0      LDA SIOSTS     ; warte bis buffer empty
          AND #$01          
          BEQ XCR0
          LDA #$0D        ; CR
          STA TBRB   
          LDX XSAVE
          JMP NEXT
;
;                                       -DISC
;                                       machine level sector R/W
;
L3030     .BYTE $85,"-DIS",$C3
          .WORD L2924    ; link to -->
          .WORD *+4
DDISC     .WORD *+2
          LDA 0,X
          STA $C60C
          STA $C60D      ; store sector number
          LDA 2,X
          STA $C60A
          STA $C60B      ; store track number
          LDA 4,X
          STA $C4CD
          STA $C4CE      ; store drive number
          STX XSAVE
          LDA $C4DA      ; sense read or write
          BNE L3032
;          JSR $E1FE
          JMP L3040
L3032 ;    JSR $E262
L3040 ;   JSR $E3EF      ; head up motor off
          LDX XSAVE
          LDA $C4E1      ; report error code
          STA 4,X
          JMP POPTWO
;
;                                       -BCD
;                             Convert binary value to BCD
;
L3050     .BYTE $84,"-BC",$C4
          .WORD L3030    ; link to -DISC
          .WORD *+4
DBCD      .WORD DOCOL
          .WORD ZERO,CLIT
          .BYTE 10
          .WORD USLAS,CLIT
          .BYTE 16
          .WORD STAR,OR,SEMIS
;
;                                       R/W
;                              Read or write one sector
;
L3060     .BYTE $83,"R/",$D7
          .WORD L3050    ; link to -BCD
          .WORD *+4
RSLW      .WORD DOCOL
          .WORD ZEQU,LIT,$C4DA,CSTOR
          .WORD SWAP,ZERO,STORE
          .WORD ZERO,OVER,GREAT,OVER
          .WORD LIT,SECTL-1,GREAT,OR,CLIT
          .BYTE 6
          .WORD QERR
          .WORD ZERO,LIT,SECTR,USLAS,ONEP
          .WORD SWAP,ZERO,CLIT
          .BYTE $12
          .WORD USLAS,DBCD,SWAP,ONEP
          .WORD DBCD,DDISC,CLIT
          .BYTE 8
          .WORD QERR
          .WORD SEMIS
;
;
;
          .WORD SEMIS
;
;                                       "
;                                       SCREEN 72 LINE 2
;
L3202     .BYTE $C1,$A7
          .WORD L3060    ; link to R/W
          .WORD *+4
TICK      .WORD DOCOL
          .WORD DFIND
          .WORD ZEQU
          .WORD ZERO
          .WORD QERR
          .WORD DROP
          .WORD LITER
          .WORD SEMIS
;
;                                       FORGET
;                                       Altered from model
;                                       SCREEN 72 LINE 6
;
L3217     .BYTE $86,"FORGE",$D4
          .WORD L3202    ; link to " TICK
          .WORD *+4
FORG      .WORD DOCOL
          .WORD TICK,NFA,DUP
          .WORD FENCE,AT,ULESS,CLIT
          .BYTE $15
          .WORD QERR,TOR,VOCL,AT
L3220     .WORD R,OVER,ULESS
          .WORD ZBRAN,L3225-*
          .WORD FORTH-INITV+INITDP,DEFIN,AT,DUP
          .WORD VOCL,STORE
          .WORD BRAN,$FFFF-24+1 ; L3220-*
L3225     .WORD DUP,CLIT
          .BYTE 4
          .WORD SUB
L3228     .WORD PFAPTR,LFA,AT
          .WORD DUP,R,ULESS
          .WORD ZBRAN,$FFFF-14+1 ; L3228-*
          .WORD OVER,TWO,SUB,STORE
          .WORD AT,DDUP,ZEQU
          .WORD ZBRAN,$FFFF-39+1 ; L3225-*
          .WORD RFROM,DP,STORE
          .WORD SEMIS
;
;                                       BACK
;                                       SCREEN 73 LINE 1
;
L3250     .BYTE $84,"BAC",$CB
          .WORD L3217    ; link to FORGET
          .WORD *+4
BACK      .WORD DOCOL
          .WORD HERE
          .WORD SUB
          .WORD COMMA
          .WORD SEMIS
;
;                                       BEGIN
;                                       SCREEN 73 LINE 3
;
L3261     .BYTE $C5,"BEGI",$CE
          .WORD L3250    ; link to BACK
          .WORD *+4
          .WORD DOCOL
          .WORD QCOMP
          .WORD HERE
          .WORD ONE
          .WORD SEMIS
;
;                                       ENDIF
;                                       SCREEN 73 LINE 5
;
L3273     .BYTE $C5,"ENDI",$C6
          .WORD L3261    ; link to BEGIN
          .WORD *+4
ENDIF     .WORD DOCOL
          .WORD QCOMP
          .WORD TWO
          .WORD QPAIR
          .WORD HERE
          .WORD OVER
          .WORD SUB
          .WORD SWAP
          .WORD STORE
          .WORD SEMIS
;
;                                       THEN
;                                       SCREEN 73 LINE 7
;
L3290     .BYTE $C4,"THE",$CE
          .WORD L3273    ; link to ENDIF
          .WORD *+4
          .WORD DOCOL
          .WORD ENDIF
          .WORD SEMIS
;
;                                       DO
;                                       SCREEN 73 LINE 9
;
L3300     .BYTE $C2,"D",$CF
          .WORD L3290    ; link to THEN
          .WORD *+4
          .WORD DOCOL
          .WORD COMP
          .WORD PDO
          .WORD HERE
          .WORD THREE
          .WORD SEMIS
;
;                                       LOOP
;                                       SCREEN 73 LINE 11
;
;
L3313     .BYTE $C4,"LOO",$D0
          .WORD L3300    ; link to DO
          .WORD *+4
          .WORD DOCOL
          .WORD THREE
          .WORD QPAIR
          .WORD COMP
          .WORD PLOOP
          .WORD BACK
          .WORD SEMIS
;
;                                       +LOOP
;                                       SCREEN 73 LINE 13
;
L3327     .BYTE $C5,"+LOO",$D0
          .WORD L3313    ; link to LOOP
          .WORD *+4
          .WORD DOCOL
          .WORD THREE
          .WORD QPAIR
          .WORD COMP
          .WORD PPLOO
          .WORD BACK
          .WORD SEMIS
;
;                                       UNTIL
;                                       SCREEN 73 LINE 15
;
L3341     .BYTE $C5,"UNTI",$CC
          .WORD L3327    ; link to +LOOP
          .WORD *+4
UNTIL     .WORD DOCOL
          .WORD ONE
          .WORD QPAIR
          .WORD COMP
          .WORD ZBRAN
          .WORD BACK
          .WORD SEMIS
;
;                                       END
;                                       SCREEN 74 LINE 1
;
L3355     .BYTE $C3,"EN",$C4
          .WORD L3341    ; link to UNTIL
          .WORD *+4
          .WORD DOCOL
          .WORD UNTIL
          .WORD SEMIS
;
;                                       AGAIN
;                                       SCREEN 74 LINE 3
;
L3365     .BYTE $C5,"AGAI",$CE
          .WORD L3355    ; link to END
          .WORD *+4
AGAIN     .WORD DOCOL
          .WORD ONE
          .WORD QPAIR
          .WORD COMP
          .WORD BRAN
          .WORD BACK
          .WORD SEMIS
;
;                                       REPEAT
;                                       SCREEN 74 LINE 5
;
L3379     .BYTE $C6,"REPEA",$D4
          .WORD L3365    ; link to AGAIN
          .WORD *+4
          .WORD DOCOL
          .WORD TOR
          .WORD TOR
          .WORD AGAIN
          .WORD RFROM
          .WORD RFROM
          .WORD TWO
          .WORD SUB
          .WORD ENDIF
          .WORD SEMIS
;
;                                       IF
;                                       SCREEN 74 LINE 8
;
L3396     .BYTE $C2,"I",$C6
          .WORD L3379    ; link to REPEAT
          .WORD *+4
IF        .WORD DOCOL
          .WORD COMP
          .WORD ZBRAN
          .WORD HERE
          .WORD ZERO
          .WORD COMMA
          .WORD TWO
          .WORD SEMIS
;
;                                       ELSE
;                                       SCREEN 74 LINE 10
;
L3411     .BYTE $C4,"ELS",$C5
          .WORD L3396    ; link to IF
          .WORD *+4
          .WORD DOCOL
          .WORD TWO
          .WORD QPAIR
          .WORD COMP
          .WORD BRAN
          .WORD HERE
          .WORD ZERO
          .WORD COMMA
          .WORD SWAP
          .WORD TWO
          .WORD ENDIF
          .WORD TWO
          .WORD SEMIS
;
;                                       WHILE
;                                       SCREEN 74 LINE 13
;
L3431     .BYTE $C5,"WHIL",$C5
          .WORD L3411    ; link to ELSE
          .WORD *+4
          .WORD DOCOL
          .WORD IF
          .WORD TWOP
          .WORD SEMIS
;
;                                       SPACES
;                                       SCREEN 75 LINE 1
;
L3442     .BYTE $86,"SPACE",$D3
          .WORD L3431    ; link to WHILE
          .WORD *+4
SPACS     .WORD DOCOL
          .WORD ZERO
          .WORD MAX
          .WORD DDUP
          .WORD ZBRAN
L3449     .WORD $0C      ; L3455-L3449
          .WORD ZERO
          .WORD PDO
L3452     .WORD SPACE
          .WORD PLOOP
L3454     .WORD $FFFC    ; L3452-L3454
L3455     .WORD SEMIS
;
;                                       <#
;                                       SCREEN 75 LINE 3
;
L3460     .BYTE $82,"<",$A3
          .WORD L3442    ; link to SPACES
          .WORD *+4
BDIGS     .WORD DOCOL
          .WORD PAD
          .WORD HLD
          .WORD STORE
          .WORD SEMIS
;
;                                       #>
;                                       SCREEN 75 LINE 5
;
L3471     .BYTE $82,"#",$BE
          .WORD L3460    ; link to <#
          .WORD *+4
EDIGS     .WORD DOCOL
          .WORD DROP
          .WORD DROP
          .WORD HLD
          .WORD AT
          .WORD PAD
          .WORD OVER
          .WORD SUB
          .WORD SEMIS
;
;                                       SIGN
;                                       SCREEN 75 LINE 7
;
L3486     .BYTE $84,"SIG",$CE
          .WORD L3471    ; link to #>
          .WORD *+4
SIGN      .WORD DOCOL
          .WORD ROT
          .WORD ZLESS
          .WORD ZBRAN
L3492     .WORD $7       ; L3496-L3492
          .WORD CLIT
          .BYTE $2D
          .WORD HOLD
L3496     .WORD SEMIS
;
;                                       #
;                                       SCREEN 75 LINE 9
;
L3501     .BYTE $81,$A3
          .WORD L3486    ; link to SIGN
          .WORD *+4
DIG       .WORD DOCOL
          .WORD BASE
          .WORD AT
          .WORD MSMOD
          .WORD ROT
          .WORD CLIT
          .BYTE 9
          .WORD OVER
          .WORD LESS
          .WORD ZBRAN
L3513     .WORD 7        ; L3517-L3513
          .WORD CLIT
          .BYTE 7
          .WORD PLUS
L3517     .WORD CLIT
          .BYTE $30
          .WORD PLUS
          .WORD HOLD
          .WORD SEMIS
;
;                                       #S
;                                       SCREEN 75 LINE 12
;
L3526     .BYTE $82,"#",$D3
          .WORD L3501    ; link to #
          .WORD *+4
DIGS      .WORD DOCOL
L3529     .WORD DIG
          .WORD OVER
          .WORD OVER
          .WORD OR
          .WORD ZEQU
          .WORD ZBRAN
L3535     .WORD $FFF4    ; L3529-L3535
          .WORD SEMIS
;
;                                       D.R
;                                       SCREEN 76 LINE 1
;
L3541     .BYTE $83,"D.",$D2
          .WORD L3526    ; link to #S
          .WORD *+4
DDOTR     .WORD DOCOL
          .WORD TOR
          .WORD SWAP
          .WORD OVER
          .WORD DABS
          .WORD BDIGS
          .WORD DIGS
          .WORD SIGN
          .WORD EDIGS
          .WORD RFROM
          .WORD OVER
          .WORD SUB
          .WORD SPACS
          .WORD TYPE
          .WORD SEMIS
;
;                                       D.
;                                       SCREEN 76 LINE 5
;
L3562     .BYTE $82,"D",$AE
          .WORD L3541    ; link to D.R
          .WORD *+4
DDOT      .WORD DOCOL
          .WORD ZERO
          .WORD DDOTR
          .WORD SPACE
          .WORD SEMIS
;
;                                       .R
;                                       SCREEN 76 LINE 7
;
L3573     .BYTE $82,".",$D2
          .WORD L3562     ; link to D.
          .WORD *+4
DOTR      .WORD DOCOL
          .WORD TOR
          .WORD STOD
          .WORD RFROM
          .WORD DDOTR
          .WORD SEMIS
;
;                                       .
;                                       SCREEN 76  LINE  9
;
L3585     .BYTE $81,$AE
          .WORD L3573    ; link to .R
          .WORD *+4
DOT       .WORD DOCOL
          .WORD STOD
          .WORD DDOT
          .WORD SEMIS
;
;                                       ?
;                                       SCREEN 76 LINE 11
;
L3595     .BYTE $81,$BF
          .WORD L3585    ; link to .
          .WORD *+4
QUES      .WORD DOCOL
          .WORD AT
          .WORD DOT
          .WORD SEMIS
;
;
L3696     .BYTE $85,"VLIS",$D4
          .WORD L3595    ; link to TRIAD
          .WORD *+4
VLIST     .WORD DOCOL
          .WORD CLIT
          .BYTE $80
          .WORD OUT
          .WORD STORE
          .WORD CON
          .WORD AT
          .WORD AT
L3706     .WORD OUT
          .WORD AT
          .WORD CSLL
          .WORD GREAT
          .WORD ZBRAN
L3711     .WORD $A       ; L3716-L3711
          .WORD CR
          .WORD ZERO
          .WORD OUT
          .WORD STORE
L3716     .WORD DUP
          .WORD IDDOT
          .WORD SPACE
          .WORD SPACE
          .WORD PFAPTR
          .WORD LFA
          .WORD AT
          .WORD DUP
          .WORD ZEQU
          .WORD QTERM
          .WORD OR
          .WORD ZBRAN
L3728     .WORD $FFD4    ; L3706-L3728
          .WORD DROP
          .WORD SEMIS
;
;                                       MON
;                                       SCREEN 79 LINE 3
;
NTOP      .BYTE $83,"MO",$CE
          .WORD L3696    ; link to VLIST
          .WORD *+4
MON       .WORD *+2
          STX XSAVE
          BRK       ; break to monitor which is assumed
          LDX XSAVE ; to save this as reentry point
          JMP NEXT
;


          .ORG $FFDC
VBRQ     .WORD 0
         .WORD 0
VINT5    .WORD 0
VINT4    .WORD 0
VINT3    .WORD 0
VINT2    .WORD 0
VCNTR1   .WORD 0
VCNTR0   .WORD 0
VTIMER2  .WORD 0
VTIMER1  .WORD 0
VTIMERY  .WORD 0
VTIMERX  .WORD 0
VTX      .WORD 0
VRX      .WORD 0
VINT1    .WORD 0
VINT0    .WORD 0
VRESET   .WORD COLD+2


TOP       .END           ; end of listing
