#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>
#include <errno.h>

#define S_PORT     7777

#define mymax(a,b) (((a) > (b)) ? (a) : (b) )
#define mymin(a,b) (((a) < (b)) ? (a) : (b) )

int nsds = -1 ;
int sd   = -1 ;

FILE * tab[2] = { 0 , 0 } ;

int telefon() {
  int rc         = 0 ;
  int yes        = 1 ;
  int fd         = 0 ;
  int flags      = 0 ;
  int clientsize = 0 ;
  FILE * fptr_in  = NULL ;
  FILE * fptr_out = NULL ;
  struct timeval tv ;
  fd_set rd ;
  fd_set wr ;
  fd_set er ;
  fd_set rd_all ;
  fd_set wr_all ;
  fd_set er_all ;
  struct sockaddr_in client ;
  struct sockaddr_in server ;

  if( sd < 0 ) {
    sd = socket(PF_INET,SOCK_STREAM,0);
    if( sd < 0 ) {
      perror("socket:");
      return -1 ;
    }
    yes = 1;
    if (setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, (char *) &yes, sizeof(yes)) < 0) {
      perror ("setsockopt");
      close (sd);
      sd = -1  ;
      return -1;
    }
    memset(&server,0,sizeof(server));
    server.sin_family       = AF_INET ;
    server.sin_addr.s_addr  = htonl(INADDR_ANY);
    server.sin_port         = htons(S_PORT);
    rc = bind(sd,(struct sockaddr *)&server,sizeof(server));
    if( rc < 0 ) {
      perror("bind:");
      close(sd) ;
      sd = -1  ;
      return -1 ;
    }
    rc = listen(sd,SOMAXCONN);
    if( rc < 0 ) {
      perror("listen:");
      close(sd);
      sd = -1  ;
      return -1 ;
    }
    FD_ZERO(&rd_all);
    FD_ZERO(&wr_all);
    FD_ZERO(&er_all);
    FD_ZERO(&rd);
    FD_ZERO(&wr);
    FD_ZERO(&er);
    FD_SET(sd,&rd_all);
    FD_SET(sd,&rd);
    nsds = sd ;
  }
  if( sd >= 0 ) {
    do {
      FD_ZERO(&rd_all);
      FD_ZERO(&wr_all);
      FD_ZERO(&er_all);
      FD_ZERO(&rd);
      FD_ZERO(&wr);
      FD_ZERO(&er);
      FD_SET(sd,&rd_all);
      FD_SET(sd,&rd);
      nsds = sd ;
      tv.tv_sec  = 0 ;
      tv.tv_usec = 100 ;
      rc = select(nsds+1,&rd,&wr,&er,&tv) ;
      if( rc < 0 ) {
	if( errno == EINTR ) {
	  return -9999 ;
	} else {
	  perror("select:");
	  return -1 ;
	}
      }
      if( rc == 0 ) {
	return -9999 ;
      }
      if( rc > 0 ) {
	if( FD_ISSET(sd,&rd) ) {
	  FD_CLR(sd,&rd);
	  printf("someone wants to connect\n");
	  clientsize = sizeof(client) ;
	  memset(&client,0,clientsize);
	  fd = accept(sd,(struct sockaddr *)&client,(int *)&clientsize);
	  printf("accept returns %d\n",fd);
	  if( fd < 0 ) {
	    perror("accept:");
	    return -1 ;
	  }
	  fptr_in  = fdopen(fd,"r");
	  fptr_out = fdopen(fd,"w");
	  tab[0]   = fptr_in ;
	  tab[1]   = fptr_out;
	  return (int) tab ;
	}
      }
    } while ( rc <= 0 ) ;
  }
  return -1 ;
}

