\ 2007-01-16 EW adv4_timeup.fs

Variable tuFlags
Variable newtimer
Variable lastsec
10  Constant cycles.tick \ timerC cycles/tick
100 Constant ticks.sec   \ ticks/second

ram
create Counts &7 cells allot
create Limits ticks.sec c, 60 c, 60 c,
              24 c, 31 c, 12 c,
rom
create MaxDay 31 c, 28 c, 31 c, 30 c,
              31 c, 30 c, 31 c, 31 c,
              30 c, 31 c, 30 c, 31 c,

: tick  ( -- addr )         Counts   ;
: sec   ( -- addr ) 1 cells Counts + ;
: min   ( -- addr ) 2 cells Counts + ;
: hour  ( -- addr ) 3 cells Counts + ;
: day   ( -- addr ) 4 cells Counts + ;
: month ( -- addr ) 5 cells Counts + ;
: year  ( -- addr ) 6 cells Counts + ;

: tickover? ( -- ) newtimer @ timer @ -  0< ;

\ --> Stephen Pelc, chapter 6
: leap_year ( year -- t/f )
  dup    4 mod 0=
  over 100 mod 0<> and
  swap 400 mod 0=  or
;
: length_of_month ( year month -- maxday )
  dup 1-                \ array starts at 0
  MaxDay + c@
  swap 2 = IF           \ if month == 2
    swap leap_year IF   \ and leap_year
      1+                \   month += 1
    ENDIF
  ELSE
    swap drop           \ remove year
  ENDIF
;
: timeup ( -- )
  cycles.tick newtimer +!
  0 tuFlags bset               \ tickflag++
  1         Counts   +!        \ tick++   <-- INC!

  \ for i in tick sec min hour day month
  6 0 DO
    I cells Counts +  @
    I       Limits + c@ >= IF  \ if C[i] >= L[i] ?
      0 I cells Counts + !     \   C[i]=0;
      I 1+ tuFlags bset        \   F[i+1]++;
      1 I 1+ cells Counts + +! \   C[i+1]++; < INC
    ENDIF                      \ endif
  LOOP
;
