\ 2007-01-16 EW adv4_main.fs

rom
include adv4_redir.fs
+redir
include adv4_tasker.fs
include adv4_timeup.fs
include adv4_lcd.fs

: get.DT ( -- S M H d m Y )
  sec @     min   @     hour  @   
  day @ 1+  month @ 1+  year  @   
;
: show.DT ( S M H d m Y -- )
  p4! type  p2! type  p2! type
  s" -" type
  p2! type  p2! type  p2! type
;
$e8   Constant portDCF \ port-D
$ea   Constant pddrDCF \ pddr-D
5     Constant pinDCF
: led2_0 ( -- ) 2 port1 bclr ;
: led2_1 ( -- ) 2 port1 bset ;
include adv4_dcf.fs

: clock.init
  2000 year !
  1    1- month !
  1    1- day !
  0    hour !
  0    min  !
  0    sec  !
;
: led3_0 ( -- ) 3 port1 bclr ;
: led3_1 ( -- ) 3 port1 bset ;
: job.tick
  tick @ ticks.sec 4 / = IF led3_0 ENDIF
  tick @  0            = IF led3_1 ENDIF
  dcf.tick
;
: job.sec
  0 13 lcdpos sec @ p2! to-lcd type
  1 0  lcdpos dcfOffset @ s>d 4 d.r
  to-stdout
;

: job.min
  to-lcd 
  0 0 lcdpos get.DT show.DT
  to-stdout
;
: job.hour
  dcfCommit dcfFlags bset
;
: job.day
;
: job.month
  year @
  month @ 1+ \ month offset 1 correction
  length_of_month
  4 Limits + c!
;
: job.year
;
: loop.init ( -- )
  clock.init
  0 tick !
  timer @ cycles.tick + newtimer !
  lcdpage get.DT to-lcd show.DT to-stdout
  job.sec
  dcf.init
;
create Jobs   ' job.tick ,
  ' job.sec , ' job.min ,   ' job.hour ,
  ' job.day , ' job.month , ' job.year ,

: run
  task
  loop.init
  BEGIN
    tickover? IF
      timeup    \ Zaehler aktualisieren
    ENDIF
    7 0 DO
      I tuFlags btst IF
	I cells Jobs + @ execute
	I tuFlags bclr
      ENDIF
    LOOP
    pause
  AGAIN
;
ram
