\ 2006-07-09 EW
\ Bytes auf uart0 verschicken

\ uart0 is on port 1
$E1 Constant port1   \ port 1
$E3 Constant pddr1   \ port direction reg. 1

&4  Constant PinTxD0 \ P1.4 is TxD0
&5  Constant PinRxD0 \ P1.5 is RxD0
                     \ uart0
$A0 Constant U0MR    \ mode register
$A4 Constant U0C0    \ control register 0
$A5 Constant U0C1    \ control register 1
&0  Constant TE      \ transmit enable bit
&1  Constant TI      \ transmit buffer empty?
$B0 Constant UCON    \ control register 2
&2  Constant U0RRM   \ receive mode bit
$A1 Constant U0BRG   \ bit rate
$A2 Constant U0TBRL  \ transmit buffer, low

: uart0-init ( -- )
  PinTxD0 port1 bset \ TxD0 is 1
  PinTxD0 pddr1 bset \ TxD0 is output
  PinRxD0 pddr1 bclr \ RxD0 is input
  $05 U0MR c!        \ 8N1, internal clock
  $00 U0C0 c!        \ clock f1, TxD0 CMOS out,
                     \ . data on falling edge,
                     \ . lsb first
  U0RRM UCON bclr    \ continuous receive OFF
  &32 U0BRG c!       \ 38400 @ 20 MHz
;

\ send one byte
: uart0emit ( n -- )
                     \ transmit buffer empty?
  BEGIN TI U0C1 btst UNTIL
  U0TBRL c!          \ n to transmit buffer
  TE U0C1 bset       \ enable transfer
;

\ send n bytes starting at addr
: uart0type ( addr n -- )
  0 DO               \ do-loop consumes n
    dup I +          \ { consumes copy of addr
    c@ uart0emit     \   get+send byte
  LOOP               \ }
  drop               \ consumes addr
;

\ send CR LF
: uart0cr ( -- )
  $0d uart0emit
  $0a uart0emit
;